<?php

namespace App\Http\Controllers;

use DB;
use App\Gasto;
use App\GastoFijo;
use Auth;
use Illuminate\Http\Request;

class GestionController extends Controller
{   

    public function indexGestion($tipo){
    	
    	switch ($tipo) {
    		case '1':
    			$data['tipo'] = "Declaracion Mensual";
    			$query = 'SELECT * from meses';
        		$periodo = DB::select($query);
        		$periodo = $this->object_to_array($periodo);
        		$data['periodos'] = $periodo;
        		$data['id_tipo'] = 1;
    			break;
    		case '2':
    			$data['tipo'] = "Declaracion Bimestral";
    			$query = 'SELECT * from periodos_bimestrales';
        		$periodo = DB::select($query);
        		$periodo = $this->object_to_array($periodo);
        		$data['periodos'] = $periodo;
        		$data['id_tipo'] = 2;
    			break;
    		case '3':
    			$data['tipo'] = "Declaracion Trimestral";
    			$query = 'SELECT * from periodos_cuatrimestres';
        		$periodo = DB::select($query);
        		$periodo = $this->object_to_array($periodo);
        		$data['periodos'] = $periodo;
        		$data['id_tipo'] = 3;
    			break;
    		case '4':
    			$data['tipo'] = "Declaracion Anual";
    			$data['periodos'] = '';
    			$data['id_tipo'] = 4;
    			break;	
    		default:
    			# code...
    			break;
    	}
    	/*print_r($data['periodos']);
    	foreach ($data['periodos'] as $key => $value) {
    		echo $value['periodo'].'<br>';
    	}
    	exit();*/
    	return view('gestion.gestioncontable')->with('data',$data);
    }
    public function object_to_array($data) {
        if (is_array($data) || is_object($data)) {
            $result = array();
            foreach ($data as $key => $value) {
                $result[$key] = $this->object_to_array($value);
            }
            return $result;
        }
    return $data;
    }
    public function get_obligaciones_presentadas(Request $r){
    	$filtro = 'where id_periocidad='.$r->tipo;
    	if($r->anio!=''){
    		$filtro.=' and anio='.$r->anio;
    	}
    	if($r->periodo!=4){
    		if($r->periodo!=0){
    			$filtro.=' and periodo='.$r->periodo;
    		}
    	}

    	$query = 'SELECT * from v_obligaciones_presentadas3 '.$filtro;

        $obligaciones = DB::select($query);
        $obligaciones = $this->object_to_array($obligaciones);
        foreach ($obligaciones as $key => $value) {
        	/*if($value['estatus']==1){
        		$estatus = '<div><span class="badge badge-primary">Sin Presentar</span></div>';
        		$acciones = '<div><button class="btn btn-info" onclick="presentar();">Presentar</button></div>';
        	}else{
        		$estatus = '<div><span class="badge badge-success">Presentada</span></div>';
        		$acciones = '';
        	}*/
            if($value['presentadas']==$value['total_obligaciones']){
                $estatus= '<div align="center"><span class="badge badge-success">Presentada</span></div>';
            }elseif($value['presentadas']>0){
                $estatus= '<div align="center"><span class="badge badge-warning">Inconpleta</span></div>';
            }elseif($value['presentadas']==0){
                $estatus= '<div align="center"><span class="badge badge-info">Sin Presentar</span></div>';
            }
        	//$estatus ='';
        	$acciones = '<button class="btn btn-info" onclick="verDetalle('.$value['id_cliente'].','.$value['id_periocidad'].','.$value['anio'].','.$value['periodo'].');">Detalle</button>';
            $conta = '<input type="checkbox" id="cbox2" value="second_checkbox">';
        	$obligaciones[$key]['estatus'] = $estatus;
        	$obligaciones[$key]['acciones'] = $acciones;
            $obligaciones[$key]['conta'] = $conta;

        }
        $resp = array('data' => $obligaciones );
        return response()->json($resp);
    }
    public function get_obligaciones_presentadas_cliente(Request $r){
    	$filtro = 'where id_cliente='.$r->id_cliente.' and id_periocidad='.$r->id_periocidad.' and anio='.$r->anio.' and periodo='.$r->periodo; 
    	$query = 'SELECT * from v_obligaciones_presentadas '.$filtro;
        $obligaciones = DB::select($query);
        $obligaciones = $this->object_to_array($obligaciones);
        foreach ($obligaciones as $key => $value) {
        	if($value['estatus']==1){
        		$estatus = '<div><span class="badge badge-primary">Sin Presentar</span></div>';
        		$acciones = '<div align="center"><input type="checkbox" id="cbox_'.$value['id'].'" class="checkObligaciones" value="'.$value['id'].'" onclick="revisaChecks();"></div>';
                $revision = '';
            }else{
        		$estatus = '<div><span class="badge badge-success">Presentada</span></div>';
        		$acciones = '<div align="center"><button class="btn btn-danger btn-sm" onclick="desPresentar('.$value['id'].');">Cancelar</button></div>';
                $revision = date("m/d/y", strtotime($value['fecha_revision']));
        	}
            $obligaciones[$key]['revisada'] = $revision;
        	$obligaciones[$key]['estatus'] = $estatus;
        	$obligaciones[$key]['acciones'] = $acciones;
        	$obligaciones[$key]['estatus_number'] = $value['estatus'];
        	$cliente = $value['nombre'];
        }
        $resp = array('data' => $obligaciones,'cliente' => $cliente );
        return response()->json($resp);
    }
    public function presentarObligaciones(Request $r){
    	//print_r($r->cadena);
        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d H:i:s");
        $idUser = Auth::user()->id; 
    	$affected = DB::table('obligaciones_presentadas')
              ->whereIn('id', $r->cadena)
              ->update([
                'estatus' => 2,
                'fecha_revision' => $fechaactual,
                'usuario' => $idUser
            ]);
        $resp = array('estatus' => 1 );
        return response()->json($resp);
    }
    public function getPercentBalance(Request $r){
        $filtro = ' and id_periocidad='.$r->tipo;
        if($r->anio!=''){
            $filtro.=' and anio='.$r->anio;
        }
        if($r->periodo!=4){
            if($r->periodo!=0){
                $filtro.=' and periodo='.$r->periodo;
            }
        }

        $query1= 'SELECT count(id) as presentadas from obligaciones_presentadas where estatus=2'.$filtro;
        $query2= 'SELECT count(id) as totales from obligaciones_presentadas where 1=1'.$filtro;


        $presentadas = DB::select($query1);
        $presentadas = $this->object_to_array($presentadas);

        $totales = DB::select($query2);
        $totales = $this->object_to_array($totales);

        //echo $presentadas[0]['presentadas'].'<<<'.$totales[0]['totales'];
        if($presentadas[0]['presentadas']!=0){
            $porcentaje = ($presentadas[0]['presentadas'] * 100) / $totales[0]['totales'];
        }else{
            $porcentaje = 0.00;
        }
        

        $resp = array('totales' => $totales[0]['totales'],'presentadas' => $presentadas[0]['presentadas'],'porcentaje' => $porcentaje );
        return response()->json($resp);

    }
    public function indexNomina($tipo){

        switch ($tipo) {
            case '1':
                $data['tipo'] = "IMSS/INFONAVIT";
                $filtro = '';
                $data['id_tipo'] = 1;
                break;
            case '2':
                $data['tipo'] = "Impuestos Estatales";
                $filtro = '';
                $data['id_tipo'] = 2;
                break;               
            case '3':
                $data['tipo'] = "RTP";
                $filtro = '';
                $data['id_tipo'] = 3;
                break;
            case '4':
                $data['tipo'] = "Nominas";
                $filtro = '';
                $data['id_tipo'] = 4;
                break;
            default:
                # code...
                break;
        }

        $query = 'SELECT * from meses';
        $periodo = DB::select($query);
        $periodo = $this->object_to_array($periodo);
        $data['periodos'] = $periodo;
        //$data['id_tipo'] = 1;

        $query = 'SELECT * from obligaciones_nominas';
        $nominas = DB::select($query);
        $nominas = $this->object_to_array($nominas);
        $data['nominas'] = $nominas;
        return view('gestion.nominas')->with('data',$data);
    }
    public function getPeriodosNomina(Request $r){
            if($r->periocidad==1){
                $query = 'SELECT * from meses';
                $periodo = DB::select($query);
                $periodo = $this->object_to_array($periodo);
            }else{
                $query = 'SELECT * from periodos_bimestrales';
                $periodo = DB::select($query);
                $periodo = $this->object_to_array($periodo);
            }
        $resp = array('periodo' => $periodo);
        return response()->json($resp);
    }   
    public function get_nominas_presentadas(Request $r){
        $filtro = 'where id_periocidad='.$r->tipo;
        if($r->anio!=''){
            $filtro.=' and anio='.$r->anio;
        }
        if($r->periodo!=4){
            if($r->periodo!=0){
                $filtro.=' and periodo='.$r->periodo;
            }
        }
        switch ($r->tipoHide) {
            case '1':
                $filtro.=' and id_obligacion in (1,2)';
                break;
            case '2':
                $filtro.=' and id_obligacion=3';
                break;  
            case '3':
                $filtro.=' and id_obligacion=4';
                break; 
            case '4':
                $filtro.=' and id_obligacion in (5,6,7)';
                break;           
            default:
                # code...
                break;
        }
        //  $filtro.=' and id_obligaccion';
        $query = 'SELECT * from v_nominas '.$filtro;
        $obligaciones = DB::select($query);
        $obligaciones = $this->object_to_array($obligaciones);
        foreach ($obligaciones as $key => $value) {
            if($value['estatus']==1){
                $estatus = '<div><span class="badge badge-primary">Sin Presentar</span></div>';
                $checkbox = '<input class="cb" type="checkbox" value="'.$value['id'].'" onclick="revisaChecks()">';
                $acciones = '<div><button class="btn btn-info btn-sm" onclick="presentarIndividual('.$value['id'].');">Presentar</button></div>';
            }else{
                $estatus = '<div><span class="badge badge-success">Presentada</span></div>';
                $checkbox = date("m/d/y", strtotime($value['fecha_revision']));
                $acciones = '<button class="btn btn-danger btn-sm" onclick="desPresentarNomina('.$value['id'].');">Cancelar</button>';
            }


            $obligaciones[$key]['estatus'] = $estatus;
            $obligaciones[$key]['acciones'] = $acciones;
            $obligaciones[$key]['check'] = $checkbox;

        }
        $resp = array('data' => $obligaciones );
        return response()->json($resp);
    }
    public function get_nominas_presentadas_cliente(Request $r){
        
        $filtro = 'where id_cliente='.$r->id_cliente.' and id_periocidad='.$r->id_periocidad.' and anio='.$r->anio.' and periodo='.$r->periodo.' and id_obligacion='.$r->id_obligacion; 
        $query = 'SELECT * from v_nominas_presentadas_cliente '.$filtro;
        $obligaciones = DB::select($query);
        $obligaciones = $this->object_to_array($obligaciones);
        foreach ($obligaciones as $key => $value) {
            if($value['estatus']==1){
                $estatus = '<div><span class="badge badge-primary">Sin Presentar</span></div>';
                $acciones = '<div align="center"><input type="checkbox" id="cbox_'.$value['id'].'" class="checkObligaciones" value="'.$value['id'].'" onclick="revisaChecks();"></div>';
            }else{
                $estatus = '<div><span class="badge badge-success">Presentada</span></div>';
                $acciones = '';
            }
            $obligaciones[$key]['estatus'] = $estatus;
            $obligaciones[$key]['acciones'] = $acciones;
            $obligaciones[$key]['estatus_number'] = $value['estatus'];
            $cliente = $value['nombre'];
        }
        $resp = array('data' => $obligaciones,'cliente' => $cliente );
        return response()->json($resp);
    }
    public function presentarNominas(Request $r){
        //print_r($r->cadena);
        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d H:i:s");
        $idUser = Auth::user()->id; 
        $affected = DB::table('nominas_presentadas')
              ->whereIn('id', $r->cadena)
              ->update([
                'estatus' => 2,
                'fecha_revision' => $fechaactual,
                'usuario' => $idUser
            ]);
        $resp = array('estatus' => 1 );
        return response()->json($resp);
    }
    public function getPercentNominas(Request $r){
       $filtro = ' AND id_periocidad='.$r->tipo;
        if($r->anio!=''){
            $filtro.=' and anio='.$r->anio;
        }
        if($r->periodo!=4){
            if($r->periodo!=0){
                $filtro.=' and periodo='.$r->periodo;
            }
        }
        switch ($r->tipoHide) {
            case '1':
                $filtro.=' and id_obligacion in (1,2)';
                break;
            case '2':
                $filtro.=' and id_obligacion=3';
                break;  
            case '3':
                $filtro.=' and id_obligacion=4';
                break; 
            case '4':
                $filtro.=' and id_obligacion in (5,6,7)';
                break;           
            default:
                # code...
                break;
        }

        $query1= 'SELECT count(id) as presentadas from nominas_presentadas where estatus=2'.$filtro;
        $query2= 'SELECT count(id) as totales from nominas_presentadas where 1=1'.$filtro;


        $presentadas = DB::select($query1);
        $presentadas = $this->object_to_array($presentadas);

        $totales = DB::select($query2);
        $totales = $this->object_to_array($totales);

        //echo $presentadas[0]['presentadas'].'<<<'.$totales[0]['totales'];
        if($presentadas[0]['presentadas']!=0){
            $porcentaje = ($presentadas[0]['presentadas'] * 100) / $totales[0]['totales'];
        }else{
            $porcentaje = 0.00;
        }
        

        $resp = array('totales' => $totales[0]['totales'],'presentadas' => $presentadas[0]['presentadas'],'porcentaje' => $porcentaje );
        return response()->json($resp);

    }
    public function desPresentarObligaciones(Request $r){
        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d H:i:s");
        $idUser = Auth::user()->id; 
        $affected = DB::table('obligaciones_presentadas')
              ->where('id', $r->id)
              ->update([
                'estatus' => 1,
                'fecha_revision' => null,
                'usuario' => $idUser
            ]);
        $resp = array('estatus' => 1 );
        return response()->json($resp);
    }
    public function presentarNominaIndividual(Request $r){
        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d H:i:s");
        $idUser = Auth::user()->id; 
        $affected = DB::table('nominas_presentadas')
              ->where('id', $r->id)
              ->update([
                'estatus' => 2,
                'fecha_revision' => $fechaactual,
                'usuario' => $idUser
            ]);
        $resp = array('estatus' => 1 );
        return response()->json($resp);
    }
    public function desPresentarNomina(Request $r){
        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d H:i:s");
        $idUser = Auth::user()->id; 
        $affected = DB::table('nominas_presentadas')
              ->where('id', $r->id)
              ->update([
                'estatus' => 1,
                'fecha_revision' => null,
                'usuario' => $idUser
            ]);
        $resp = array('estatus' => 1 );
        return response()->json($resp);
    }
    public function indexDIOTELCE($tipo){

        switch ($tipo) {
            case '1':
                $data['tipo'] = "DIOT";
                $filtro = '';
                $data['id_tipo'] = 1;
                break;
            case '2':
                $data['tipo'] = "Contabilidad Electronica";
                $filtro = '';
                $data['id_tipo'] = 2;
                break;               
            default:
                # code...
                break;
        }

        $query = 'SELECT * from meses';
        $periodo = DB::select($query);
        $periodo = $this->object_to_array($periodo);
        $data['periodos'] = $periodo;
        //$data['id_tipo'] = 1;

        $query = 'SELECT * from obligaciones_nominas';
        $nominas = DB::select($query);
        $nominas = $this->object_to_array($nominas);
        $data['nominas'] = $nominas;
        return view('gestion.diot')->with('data',$data);
    }
    public function get_diot_presentada(Request $r){
        $filtro = 'where id_periocidad='.$r->tipo;
        if($r->anio!=''){
            $filtro.=' and anio='.$r->anio;
        }
        if($r->periodo!=4){
            if($r->periodo!=0){
                $filtro.=' and periodo='.$r->periodo;
            }
        }

        switch ($r->tipoHide) {
            case '1':
                $filtro.=' and id_obligacion=18';
                break;
            case '2':
                $filtro.=' and id_obligacion=17';
                break;           
            default:
                # code...
                break;
        }
                //  $filtro.=' and id_obligaccion';
        $query = 'SELECT * from v_diot '.$filtro;
        $obligaciones = DB::select($query);
        $obligaciones = $this->object_to_array($obligaciones);
        foreach ($obligaciones as $key => $value) {
            if($value['estatus']==1){
                $estatus = '<div><span class="badge badge-primary">Sin Presentar</span></div>';
                $checkbox = '<input class="cb" type="checkbox" value="'.$value['id'].'" onclick="revisaChecks()">';
                $acciones = '<div><button class="btn btn-info btn-sm" onclick="presentarIndividual('.$value['id'].');">Presentar</button></div>';
            }else{
                $estatus = '<div><span class="badge badge-success">Presentada</span></div>';
                $checkbox = date("m/d/y", strtotime($value['fecha_revision']));
                $acciones = '<button class="btn btn-danger btn-sm" onclick="desPresentarNomina('.$value['id'].');">Cancelar</button>';
            }


            $obligaciones[$key]['estatus'] = $estatus;
            $obligaciones[$key]['acciones'] = $acciones;
            $obligaciones[$key]['check'] = $checkbox;

        }
        $resp = array('data' => $obligaciones );
        return response()->json($resp);
    }
    public function presentar_diot_individual(Request $r){
        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d H:i:s");
        $idUser = Auth::user()->id; 
        $affected = DB::table('obligaciones_presentadas')
              ->where('id', $r->id)
              ->update([
                'estatus' => 2,
                'fecha_revision' => $fechaactual,
                'usuario' => $idUser
            ]);
        $resp = array('estatus' => 1 );
        return response()->json($resp);
    }
    public function getPercentDiots(Request $r){
       $filtro = ' AND id_periocidad='.$r->tipo;
        if($r->anio!=''){
            $filtro.=' and anio='.$r->anio;
        }
        if($r->periodo!=4){
            if($r->periodo!=0){
                $filtro.=' and periodo='.$r->periodo;
            }
        }
        switch ($r->tipoHide) {
            case '1':
                $filtro.=' and id_obligacion=18';
                break;
            case '2':
                $filtro.=' and id_obligacion=17';
                break;           
            default:
                # code...
                break;
        }

        $query1= 'SELECT count(id) as presentadas from obligaciones_presentadas where estatus=2'.$filtro;
        $query2= 'SELECT count(id) as totales from obligaciones_presentadas where 1=1'.$filtro;


        $presentadas = DB::select($query1);
        $presentadas = $this->object_to_array($presentadas);

        $totales = DB::select($query2);
        $totales = $this->object_to_array($totales);

        //echo $presentadas[0]['presentadas'].'<<<'.$totales[0]['totales'];
        if($presentadas[0]['presentadas']!=0){
            $porcentaje = ($presentadas[0]['presentadas'] * 100) / $totales[0]['totales'];
        }else{
            $porcentaje = 0.00;
        }
        

        $resp = array('totales' => $totales[0]['totales'],'presentadas' => $presentadas[0]['presentadas'],'porcentaje' => $porcentaje );
        return response()->json($resp);

    }
}
