<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Cliente extends Model
{
    public $timestamps = false;
    protected $table = 'ias_clientes';
    protected $primaryKey = "idCliente";
    protected $fillable = array(
        'idCuba',
        'nombre',
        'direccion',
        'idPais',
        'email',
        'telefono',
        'comision',
        'estatus',
        'idUsuario',
    );

    public function ventas()
    {
        return $this->hasMany('App\Venta', 'idCliente');
    }
}
