<?php

namespace App\Console\Commands;

use App\TipoDeCambio;
use Illuminate\Console\Command;

class UpdateForeignExchange extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'foreignexchange:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //
        $client = new \GuzzleHttp\Client();
        $response = $client->get( 'https://www.banxico.org.mx/SieAPIRest/service/v1/series/SF43718%2CSF46410/datos/oportuno?token=85764148dbb6533a06291da5a653fc0773be68511c956c0dca8cab948d8c234b', [
            'headers' => [
                "Accept" => "application/json"
            ]
        ])->json(); 

        foreach( $response['bmx']['series'] as $tipoCambio) {

            if( $tipoCambio['idSerie'] == 'SF43718' ) {
                TipoDeCambio::create([
                    'moneda' => 'USD',
                    'monto' => $tipoCambio['datos'][0]['dato'],
                ]);
            } else if( $tipoCambio['idSerie'] == 'SF46410' ) {
                TipoDeCambio::create([
                    'moneda' => 'EUR',
                    'monto' => $tipoCambio['datos'][0]['dato'],
                ]);
            }
        }
        
    }
}
