<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Organizacion;
use App\TipoDeCambio;

class MonedaController extends Controller
{


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit( $currency )
    {
        //
        $monto = TipoDeCambio::query()->where('moneda', $currency)->orderBy('id', 'desc') ->first()->monto;
        $porcentaje =  ($currency == 'USD') ? Organizacion::find(1)->porcentaje_dolar : Organizacion::find(1)->porcentaje_euro;

        $total = $monto + ( $monto / 100 * $porcentaje );
        
        return view('admin.config.moneda', ['moneda' => $currency, 'monto' => $monto, 'porcentaje' => $porcentaje, 'total' => $total ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $currency)
    {
        //
        $organizacion = Organizacion::find(1);
        if($currency == 'USD') 
            $organizacion->porcentaje_dolar = $request['aumento_porcentaje'];
        else
            $organizacion->porcentaje_euro = $request['aumento_porcentaje'];

        $organizacion->save();
        return redirect( $request->url() );
    }
}
