<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Venta extends Model
{
    //
    public $timestamps = false;
    protected $table = 'ventas';
    protected $fillable = array(
        'idCliente',
        'total',
        'iva_comision',
        'iva_bancaria',
        'payment_id',
        'moneda',
        'tipo_cambio_id',
        'porcentaje_tipo_cambio',
        'fecha',
        'tipo',
        'comision_bancaria',
        'comision_integrity',
        'porcentaje_comision_bancaria',
        'porcentaje_comision_integrity',
        'factura_dir',
        'comentarios',
        'estatus',
        'factura_url',
    );

    public function lineas()
    {
        return $this->hasMany('App\VentaServicio', 'id_venta');
    }

    
}