@extends('includes.navbarclient')
@section('content')
<div class="container-fluid" id="xd">
	<div class="row" style="height: 100%;">
		<!--<div class="col-2" style="background-color: #93a6b7">
			<div class="row">
				<div class="col-12">
					<h1>{{ trans( 'messages.ventas' ) }}</h1>
				</div>
			</div>
			<hr>
			<div class="row">
				<div class="col-12 alert alert-dark">
                    <br>
					<h5><a href="{{ asset('/admin/customers') }}">+ {{ trans( 'messages.ventas' ) }}</a></h5>
				</div>
			</div>
		</div>-->
		<div class="col-12" id="divFormCliente" >
			<div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <br>
                        <h5>+ {{ trans( 'messages.ventas' ) }}</h5>

                    </div>
                </div>
                {{-- <div class="row">
                    <div class="col-9"></div>
                    <div class="col-3">
                        @can('create-extraordinaysale')
                            <a href="" class="btn ">{{ trans( 'messages.crear_venta_extraordinaria' ) }}</a>
                        @endcan
                    </div>
                </div> --}}
                <div class="row">
                    <div class="col-9">
                        <form method="get" action="{{ url('customers/'. $cliente->idCliente . '/transactions') }}">
                            <div class="form-inline form-dates">
                                <label for="from" class="form-label-sm">{{ trans('messages.fecha') }}</label>&nbsp;
                                <div class="input-group">
                                    <input type="text" class="form-control form-control-sm datepicker" name="from" id="from" placeholder="{{ trans('messages.desde') }}" value="{{ request('from') }}">
                                </div>
                                <div class="input-group">
                                    <input type="text" class="form-control form-control-sm datepicker" name="to" id="to" placeholder="{{ trans('messages.hasta') }}" value="{{ request('to') }}">
                                </div>
                                &nbsp;
                                <label for="from" class="form-label-sm">{{ trans('messages.estatus') }}</label>&nbsp;
                                <div class="input-group">
                                    <select class="form-control" name="estatus" id="estatus">
                                        <option value="-">-{{ trans('messages.todas') }}-</option>
                                        <option value="2">{{ trans('messages.pagadas') }}</option>
                                        <option value="1">{{ trans('messages.porpagar') }}</option>
                                        <option value="0">{{ trans('messages.pendinete') }}</option>
                                    </select>
                                </div>  
                                <button type="submit" class="btn btn-sm btn-primary">{{ trans('messages.filtrar') }}</button>
                            </div>
                        </form>

                    </div>
                    <div class="col-3">
                        <label for="">{{ trans('messages.cliente') }}</label>
                        <input type="text" value="{{ $cliente->nombre }}" class="form-control" readonly>
                    </div>
                </div>
                <br>

                <div class="row">
                    <div class="col-12">
                        <table id="transactions" class="table table-bordered table-hover" style="background-color: white;">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>{{ trans('messages.fecha') }}</th>
                                    {{-- <th>{{ trans('messages.id_servicio') }}</th> --}}
                                    <th>{{ trans('messages.moneda') }}</th>
                                    <th>{{ trans('messages.precio') }}</th>
                                    <th>{{ trans('messages.estatus') }}</th>
                                    <th>{{ trans('messages.tipo_venta') }}</th>
                                    <th>{{ trans('messages.acciones') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ( $ventas as $venta )
                                
                                    <tr>
                                        <td>{{ $venta->id }}</td>
                                        <td>{{ $venta->fecha }}</td>
                                        <td>{{ $venta->moneda }}</td>
                                        <td class="text-right">${{ number_format($venta->total, 2) }}</td>
                                        <td> 
                                        @if ($venta->estatus == 0)
                                            <span class="badge badge-pill badge-warning">Pendiente</span>
                                        @endif 
                                        @if ($venta->estatus == 1)
                                            <span class="badge badge-pill badge-danger">{{ trans('messages.por_pagar') }}</span>
                                        @endif 
                                        @if ($venta->estatus == 2)
                                            <span class="badge badge-pill badge-success">{{ trans('messages.pagado') }}</span>
                                        @endif 
                                        </td>
                                        <td>{{ $venta->tipo == 1 ? trans('messages.ordinaria') : trans('messages.extraordinaria') }}</td>
                                        <td><a href="{{ asset('/customers/'.$cliente->idCliente.'/transactions/'.$venta->id ) }}">{{ trans('messages.resumen') }}</a></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                        
                </div>
			</div>
		</div>
	</div>
</div>
<script>
$(document).ready(function() {
    $('#transactions').DataTable({
        "order": [[ 1, "desc" ]]
    });
} );

$('#from').datepicker({ format: 'yyyy-mm-dd' });
$('#to').datepicker({ format: 'yyyy-mm-dd' });
</script>
@endsection
