<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use DB;
use Auth;
use Input;
use Session;
use DateTime;
use DateTimeZone;
use App\Models\sc_usuarios;
use App\Models\Cliente;
use App\Country;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Illuminate\Http\Request;
//use Yajra\DataTables\DataTables;


class ClienteController extends Controller
{
    public function gridClientes(){
    	$query = 'SELECT * from paises';
    	$paises = DB::select($query);
    	$paises = $this->object_to_array($paises);

    	$query = 'SELECT * from ias_proveedores';
    	$proves = DB::select($query);
    	$proves = $this->object_to_array($proves);

    	return view('cliente.gridclientes')->with('paises',$paises)->with('proves',$proves);
    }
    public function saveCliente(Request $request){
    	$idCuba = $request->idCuba;
		$nombre = $request->nombre;
		$email = $request->email;
		$tel = $request->tel;
		$pais = $request->pais;
		$direccion = $request->direccion;
		$prove = $request->prove;
		$prove_email = $request->prove_email;
		$estatus = $request->estatus;
        $comision = $request->comision;
        $id = $request->id;

        if($id==''){
                $idIns = DB::table('ias_clientes')->insertGetId([
                    'idCuba' =>  $idCuba,
                    'nombre' => $nombre,
                    'direccion' => $direccion,
                    'idPais' => $pais,
                    'email' => $email,
                    'telefono' => $tel,
                    'comision' => $comision,
                ]);
            $resp = array('id' => $idIns );
            echo json_encode($resp);
        }else{
            $idIns = DB::table('ias_clientes')
              ->where('idCliente', $id)
              ->update([
                    'idCuba' =>  $idCuba,
                    'nombre' => $nombre,
                    'direccion' => $direccion,
                    'idPais' => $pais,
                    'email' => $email,
                    'telefono' => $tel,
                    'comision' => $comision,
                    'estatus' => $estatus,
                ]);
            $resp = array('id' => 1 );
            echo json_encode($resp);
        }

	
		//return response()->json(array('id' => $idIns));
    }
    public function object_to_array($data) {
        if (is_array($data) || is_object($data)) {
            $result = array();
            foreach ($data as $key => $value) {
                $result[$key] = $this->object_to_array($value);
            }
            return $result;
        }
    return $data;
    }
    public function getClientes(){
	 $clientes = Cliente::get()->toArray();
	 //dd($clientes);
	 //exit();
        foreach ($clientes as $key => $value) {
            $clientes[$key]['acciones'] = '<button class="btn btn-primary" onclick="getEditaDatos('.$value['idCliente'].')"><i class="fa fa-pencil-alt"></i></button>';
            $pais = Country::find($value['idPais']);
            if($pais==null){
		    //echo $value['idCliente'].'<br>';
		$paisx = '';
	    }else{
	    	$paisx = $pais->code;
	    }
	    //$clientes[$key]['pais_display'] = $pais->code;
	    $clientes[$key]['pais_display'] = $paisx;
            if($value['estatus']==1){
                $est = '<span class="badge badge-pill badge-success">Activo</span>';
            }else{
                $est = '<span class="badge badge-pill badge-danger">Inactivo</span>';               
            }
            $clientes[$key]['estatus'] = $est;
        }
    	$resp = array('data' => $clientes );
		echo json_encode($resp);


    }
    public function saveProve(Request $request){
    	$idIns = DB::table('ias_proveedores')->insertGetId([
			'nombre' => $request->nombre,
			'correo' => $request->correo,
		]);
		$resp = array('id' => $idIns );
		echo json_encode($resp);
    }
    public function rangos__(){
        $query = 'SELECT * from ias_proveedores';
        $proves = DB::select($query);
        $proves = $this->object_to_array($proves);

        return view('cliente.gridclientes')->with('paises',$paises)->with('proves',$proves);
    }
    public function datosCliente(Request $r){
        $cliente = Cliente::find($r->id)->toArray();
        $resp = array('cliente' => $cliente );
        echo json_encode($resp);
    }
    public function rangos(){
        return view('configuracion.rangos');
    }
    public function getRangos(){
        $query = 'SELECT * from rangos_comisiones';
        $rangos = DB::select($query);
        $rangos = $this->object_to_array($rangos);
        foreach ($rangos as $key => $value) {
             if($value['estatus']==1){
                $estatus = '<div align="center"><span class="badge badge-primary">Activo</span></div>';
            }else{
                $estatus = '<div align="center"><span class="badge badge-danger">Inactivo</span></div>';
            }
            $rangos[$key]['estatus'] = $estatus;
            $rangos[$key]['porcentaje'] = $value['porcentaje'].'%';
            $rangos[$key]['acciones'] = '<button class="btn btn-primary" onclick="getEditaDatos('.$value['id'].')"><i class="fa fa-pencil-alt"></i></button>';
        }
        $resp = array('data' => $rangos );
        echo json_encode($resp);
    }
    public function guardaRango(Request $request){
        if($request->id==''){
            $idIns = DB::table('rangos_comisiones')->insertGetId([
                'desde' => $request->desde,
                'hasta' => $request->hasta,
                'porcentaje' => $request->porcentaje,
                'estatus' => $request->estatus,
            ]);
            $resp = array('id' => $idIns );
            echo json_encode($resp);
        }else{
            $idIns = DB::table('rangos_comisiones')
              ->where('id', $request->id)
              ->update([
                'desde' => $request->desde,
                'hasta' => $request->hasta,
                'porcentaje' => $request->porcentaje,
                'estatus' => $request->estatus,
                ]);
            $resp = array('id' => 1 );
            echo json_encode($resp);
        }
    }
    public function datosRango(Request $request){
        $query = 'SELECT * from rangos_comisiones where id='.$request->id;
        $rangos = DB::select($query);
        $rangos = $this->object_to_array($rangos);
      
        $resp = array('rangos' => $rangos[0] );
        echo json_encode($resp);
    }
    public function import_excel(Request $request){
        
        \Excel::load($request->excel, function($reader) {
        $paiseError = array();
        $datos_a_insertar = array();
        $excel = $reader->get();
        //$key = 0;
        // iteracción
        $reader->each(function($row) {
            /*$query = "SELECT * from paises where pais like '%".$row->pais."%'";
            $pais = DB::select($query);
            $idPaiss = 0;
            //$pais = $this->object_to_array($pais);
            if($pais==null){
                //echo $row->pais.'<br>';
                $j = $row->pais;
                //array_push($paiseError,$row->pais);
                //array_push($paiseError, $j);
            }else{
                $datos_a_insertar[$key]['idCuba'] = $row->cliente;
                $datos_a_insertar[$key]['nombre'] = $row->nombre;
                $datos_a_insertar[$key]['direccion'] = $row->direccion;
                $datos_a_insertar[$key]['idPais'] = $idPaiss;
                $datos_a_insertar[$key]['email'] = $row->email;
                $datos_a_insertar[$key]['telefono'] = $row->telefono;
                $datos_a_insertar[$key]['comision'] = 10;
            }*/

            //$key++;
                $idIns = DB::table('ias_clientes')->insertGetId([
                    'idCuba' =>  $row->cliente,
                    'nombre' => $row->nombre,
                    'direccion' => $row->direccion,
                    'idPais' => intval($row->direccion),
                    'email' => $row->email,
                    'telefono' => $row->telefono,
                    'comision' => 10,
                ]);


 
        });
    
    });
        return redirect('/admin/clientes');
    }
    public function seeData(){
        //echo Auth::user()->cliente->idCliente;
        $idUser = Auth::user()->cliente->idCliente;
        $select = 'SELECT a.idCliente,a.nombre,a.email,a.direccion,a.telefono,b.name,b.email,b.password,b.remember_token,a.idUsuario
                from ias_clientes a
                left join users b on a.idUsuario=b.id
                where a.idCliente='.$idUser;
        $data = DB::select($select);
        $data = $this->object_to_array($data);       

        return view('cliente.profile')->with('datos',$data[0]); 
    }
    public function cambia_password(Request $r){
        /*$select = 'SELECT * from users where id='.$r->idUsuario;
        $data = DB::select($select);
        $data = $this->object_to_array($data); */
        $user = User::find($r->idUsuario);
        //echo decrypt($user->password);
       $e = Hash::check('plain-text', $user->password);
       dd($e);
        //$passActual = decrypt($data[0]['password']);
    }
}
