<?php

namespace App\Http\Controllers;

use Auth;
use App\Http\Requests;
use DB;
use Input;
use Session;
use DateTime;
use DateTimeZone;
use App\Models\sc_usuarios;
use App\Models\Servicio;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

//use MercadoPago;
use MercadoPago\Item;
use MercadoPago\MerchantOrder;
use MercadoPago\Payer;
use MercadoPago\Payment;
use MercadoPago\Preference;
use MercadoPago\SDK;


class ServicioController extends Controller
{   
    public function gridServicios(){
        $query = 'SELECT * from ias_clasificadores';
        $clasi = DB::select($query);
        $clasi = $this->object_to_array($clasi);

        return view('servicios.gridservicios')->with('clasificadores',$clasi);
    }
    public function getTableServicios(){
        $query = 'SELECT s.*,c.nombre as clasificador
                from ias_servicio s
                left join ias_clasificadores c on s.idClasificador=c.idClasificador';
        $servicios = DB::select($query);
        $servicios = $this->object_to_array($servicios);

        foreach ($servicios as $key => $value) {
            if($value['estatus']==1){
                $estatus = '<div align="center"><span class="badge badge-primary">Activo</span></div>';
            }else{
                $estatus = '<div align="center"><span class="badge badge-danger">Inactivo</span></div>';
            }
            $servicios[$key]['estatus'] = $estatus;
            $servicios[$key]['acciones'] = '<button class="btn btn-primary" onclick="getEditaDatos('.$value['idServicio'].')"><i class="fa fa-pencil-alt"></i></button>';
        }
        $resp = array('data' => $servicios );
        echo json_encode($resp);
    }
    public function object_to_array($data) {
        if (is_array($data) || is_object($data)) {
            $result = array();
            foreach ($data as $key => $value) {
                $result[$key] = $this->object_to_array($value);
            }
            return $result;
        }
    return $data;
    }
    public function saveServicio(Request $request){
        if($request->idServ==''){
            $idIns = DB::table('ias_servicio')->insertGetId([
                'numero_servicio' =>  $request->numeroServicio,
                'nombre' => $request->nombre,
                'idClasificador' => $request->clasificador,
                'precio_bruto' => $request->bruto,
                'moneda' => $request->moneda,
                'comisionIAS' => $request->comisionIAS,
                'comisionPago' => $request->comisionPago,
                'tipoCambio' => $request->tipoCambio,
                'precio_total' => $request->total,
            ]);
            $resp = array('id' => $idIns );
        }else{

            $idIns = DB::table('ias_servicio')
                ->where('idServicio',$request->idServ)
                ->update([
                    'numero_servicio' =>  $request->numeroServicio,
                    'nombre' => $request->nombre,
                    'idClasificador' => $request->clasificador,
                    'precio_bruto' => $request->bruto,
                    'moneda' => $request->moneda,
                    'comisionIAS' => $request->comisionIAS,
                    'comisionPago' => $request->comisionPago,
                    'tipoCambio' => $request->tipoCambio,
                    'precio_total' => $request->total,
                ]);
            $resp = array('id' => 2 );
            echo json_encode($resp);
        }

        //echo json_encode($resp);
    }
    public function datosServicio(Request $request){
        $servicio = Servicio::find($request->id)->toArray();
        $resp = array('servicio' => $servicio );
        echo json_encode($resp);
    }
    public function gridServiciosVentas(){
        $idCliente = Auth::user()->cliente->idCliente;
        $query = 'SELECT * from ias_servicio where estatus=1';
        $servicios = DB::select($query);
        $servicios = $this->object_to_array($servicios);

        $query = 'SELECT * from ventas where estatus=1 and idCliente='.$idCliente.' order by id desc';
        $pendientes = DB::select($query);
        $pendientes = $this->object_to_array($pendientes);

        $query = 'SELECT count(id) as total from ventas where estatus=1 and idCliente='.$idCliente;
        $pendientesTotal = DB::select($query);
        $pendientesTotal = $this->object_to_array($pendientesTotal);

        $query = 'SELECT comision_bancaria_eur,comision_bancaria_usd,porcentaje_dolar,porcentaje_euro from organizacion where id=1';
        $comisionBancaria = DB::select($query);
        $comisionBancaria = $this->object_to_array($comisionBancaria);


        $query = 'SELECT * from ias_clientes where idCliente='.$idCliente;
        $comisionCliente = DB::select($query);
        $comisionCliente = $this->object_to_array($comisionCliente);
        //print_r($pendientes);
        //exit();

        //return view('servicios.gridservicios')->with('clasificadores',$clasi);
        return view('servicios.ventasservicios')->with('servicios',$servicios)->with('pendientes',$pendientes)->with('total',$pendientesTotal[0]['total'])->with('comisiones',$comisionBancaria)->with('comisionesIAS',$comisionCliente);
    }
    public function pagos_prueba(){
        //echo 'deede';
        //exit();
        return view('servicios.pagoprueba');
    }
    public function pagar(){

        // Agrega credenciales

        SDK::setAccessToken(env('PROD_ACCESS_TOKEN'));
        $payer = new Payer();
        $payer->name = "Charles";
        $payer->surname = "Luevano";
        $payer->email = "charles@hotmail.com";
        $payer->date_created = "2018-06-02T12:58:41.425-04:00";
        $payer->phone = array(
        "area_code" => "",
        "number" => "949 128 866"
        );

        $payer->identification = array(
        "type" => "DNI",
        "number" => "12345678"
        );

        $payer->address = array(
        "street_name" => "Cuesta Miguel Armendáriz",
        "street_number" => 1004,
        "zip_code" => "11020"
        );
        
        // Crea un objeto de preferencia
        $preference = new Preference();

        // Crea un ítem en la preferencia
        $item = new Item();
        $item->title = 'Mi producto';
        $item->quantity = 1;
        $item->unit_price = 75;
        $preference->items = array($item);
        $preference->save();
        //dd($preference);
        /*$mp = new MP( env('MP_ACCESS_TOKEN') );
        dd($mp);
        exit();
        $payment_data = array(
            "transaction_amount" => 100,
            "token" => $request->token,
            "description" => "Descripcion del pago",
            "installments" => 1,
            "payment_method_id" => $request->paymentMethodId,
            "payer" => array (
                "email" => $request->email,
            )
        );

        $payment = $mp->post("/v1/payments", $payment_data);

        dd($payment);*/
        return view('servicios.pagoprueba')->with('preference',$preference);

    }
    public function descarga_fact(Request $r)
    {
        return response()->download( storage_path('app'). '/' . $r->factura_url );
    }
}
