<?php

namespace App\Http\Controllers;

use App\Cliente;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Models\Organizacion;
use App\Models\Servicio;
use App\Venta;
use App\TipoDeCambio;
use App\User;
use App\VentaServicio;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use ZipArchive;

class TransactionController extends Controller
{

    public function customerIndex(Request $request) {

        $search = $request['search'];
        $clientes = Cliente::query()
            ->when(request('search'), function ($query) use ($search) {
                return $query->where('nombre', 'like', "%{$search}%");
            })
            ->orderBy('idCliente', 'desc')
            ->get();


        return view('admin.customers', compact( 'clientes'));
    }




    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, \App\Cliente $customer)
    {
        //
        $cliente = $customer;

        $from = $request['from'];
        $to = $request['to'];
	$estatus = $request['estatus'];

        if($estatus=='-' || $estatus==''){
            $ventas = Venta::query()
                ->where('idCliente', $cliente->idCliente)
                ->when(request('from'), function ($query) use ($from) {
                    return $query->whereDate('fecha', '>=', $from);
                })
                ->when(request('to'), function ($query) use ($to) {
                    return $query->whereDate('fecha', '<=', $to);
                })
                ->orderBy('fecha', 'desc')
                ->get();
        }else{
            $ventas = Venta::query()
                ->where('idCliente', $cliente->idCliente)
                ->when(request('from'), function ($query) use ($from) {
                    return $query->whereDate('fecha', '>=', $from);
                })
                ->when(request('to'), function ($query) use ($to) {
                    return $query->whereDate('fecha', '<=', $to);
                })
                ->where('estatus',$estatus)
                ->orderBy('fecha', 'desc')
                ->get();
	}

	// dd($ventas);
        return view('customers.transactions', ['cliente' => $cliente, 'ventas' => $ventas]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //

        return view('admin.transactions');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        //
        $organizacion =  Organizacion::find(1);
        $cliente = Cliente::find( $request['id_cliente'] );
        $tipoDeCambio = TipoDeCambio::query()->where( 'moneda', $request['moneda'] )->orderBy('id', 'desc') ->first();

        $comisionBancaria = (  ($request['moneda'] == 'USD') ? $organizacion->comision_bancaria_usd : $organizacion->comision_bancaria_eur  );
	$comisionBancaria = 0;
	$impuestoComisionBancaria = $comisionBancaria * 0.16;
        $total = $comisionBancaria + $impuestoComisionBancaria;

        
        $nuevaVenta = Venta::create([
            'idCliente' => $request['id_cliente'],
            'total' => $total,
            'iva_comision' => 0,
            'iva_bancaria' => $impuestoComisionBancaria,
            'moneda' => $request['moneda'],
            'tipo_cambio_id' => $tipoDeCambio->id,
            'porcentaje_tipo_cambio' => (  ($request['moneda'] == 'USD') ? $organizacion->porcentaje_dolar : $organizacion->porcentaje_euro  ),
            'fecha' => Carbon::now(),
            'tipo' => 2,
            'comision_bancaria' => $comisionBancaria,
            'comision_integrity' => 0,
            //'porcentaje_comision_bancaria' => $organizacion->comision_bancario,
            'porcentaje_comision_integrity' => $cliente->comision,
            'estatus' => 0,
        ]);
        
        return redirect('/admin/transactions/'.$nuevaVenta->id);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(\App\Cliente $customer, \App\Venta $transaction )
    {
        //
        $cliente = $customer;
        $venta = $transaction;
        $lineas = $transaction->lineas;
        $tipoDeCambio = TipoDeCambio::find( $transaction->tipo_cambio_id );

        return view('customers.transactions.line', ['cliente' => $cliente, 'venta' => $venta, 'lineas' => $lineas, 'tipoDeCambio' => $tipoDeCambio ]);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(\App\Venta $transaction )
    {
        //
        $cliente = Cliente::find( $transaction->idCliente );
        $tipoDeCambio = TipoDeCambio::find( $transaction->tipo_cambio_id );

        return view('admin.transaction', [ 'cliente' => $cliente, 'transaction' => $transaction, 'tipoDeCambio' => $tipoDeCambio ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, \App\Venta $transaction)
    {
        //
        $costo = $request['precio'];
        $organizacion = Organizacion::find(1);
        $porcentajeComisionIntegrity = $transaction->porcentaje_comision_integrity;
	$porcentajeComisionIntegrity = 14;
	// $porcentajeComisionBancaria = $transaction->porcentaje_comision_bancaria;
	$comisionBancaria = $organizacion->comision_bancaria_eur;
        $comisionBancaria = 0;
        $comisionIntegrity = ( $costo * $porcentajeComisionIntegrity ) / 100;

        $totalSinComisionBancaria = $costo + $comisionIntegrity;


        //* $comisionBancaria = ( $totalSinComisionBancaria * $porcentajeComisionBancaria ) / 100;


        $impuestoComisionIntegrity = $comisionIntegrity * 0.16;

         $impuestoComisionBancaria = $comisionBancaria * 0.16;

        $subtotal = $costo + $comisionIntegrity + $comisionBancaria;
        $impuestos = $impuestoComisionIntegrity + $impuestoComisionBancaria;
        $total = $subtotal + $impuestos;

        $transaction->lineas()->create([
            'id_servicio' =>  $request['id_serviceio'],
            'precio_unitario' => $request['precio'],
            'subtotal' => $subtotal,
            'precio_total' => $total,
            'cantidad' => 1,
            'comision_integrity' => $comisionIntegrity,
            'comision_bancaria' => $comisionBancaria,
            'iva_integrity' => $impuestoComisionIntegrity,
            'iva_comision_bancaria' => $impuestoComisionBancaria,
        ]);


        $transaction->total = 0;
        $transaction->comision_integrity = 0;
        $transaction->iva_comision = 0;
        $transaction->comision_bancaria = 0;
        $transaction->iva_bancaria = 0;
        foreach( $transaction->lineas as $l ) {
            $transaction->total += $l->precio_total;
            $transaction->comision_integrity += $l->comision_integrity;
            $transaction->iva_comision += $l->iva_integrity;
            $transaction->comision_bancaria += $l->comision_bancaria;
            $transaction->iva_bancaria += $l->iva_comision_bancaria;
        }
        //$transaction->total += $transaction->comision_bancaria + $transaction->iva_bancaria;

        $transaction->save();


        //dd( $transaction );


        //return redirect( url($transaction->id) );
        return redirect('/admin/transactions/'.$transaction->id);
    }

    public function confirm(Request $request, \App\Venta $transaction)
    {
        $transaction->estatus = 1;
        $transaction->save();

        return redirect('/customers/'.$transaction->idCliente.'/transactions/'.$transaction->id);
    }

    public function factura(Request $request, \App\Venta $transaction)
    {   

       $files = $request->file('factura');
            $contador = 0;
            $namesFilesSql = '';
            foreach ($files as $file) { 
                if($contador>0){
                    $namefile = $transaction->id.'-'.$contador;
                }else{
                    $namefile = $transaction->id;
                }
                $namesFilesSql.=$namefile.'.pdf,';
                Storage::disk('local')->put( $namefile.'.pdf' ,  File::get($file) );
                $contador++;
            }       
            $transaction->factura_url = trim($namesFilesSql,',');
            $transaction->save();   

        return redirect('/customers/'.$transaction->idCliente.'/transactions/'.$transaction->id);
    }

    public function descargarFactura(Request $request, \App\Venta $transaction)
    { 
        $ids = explode(',', $transaction->factura_url);
        $Numfiles = sizeof($ids);
        if($Numfiles!='1'){
            $zip = new ZipArchive;
            $zipFileName ="IASInvoices_". $transaction->id.'.zip';
            if ($zip->open(storage_path('app'). '/' . $zipFileName, ZipArchive::CREATE) === TRUE) {
                foreach ($ids as $key => $value) {
                    //return response()->download( storage_path('app'). '/' . $value );
                     storage_path('app'). '/' . $value;
                      $zip->addFile(storage_path('app'). '/' . $value,$value);
                }
                $zip->close();
                // Set Header
                $headers = array(
                    'Content-Type' => 'application/octet-stream',
                );
                $filetopath=storage_path('app').'/'.$zipFileName;
                // Create Download Response
                if(file_exists($filetopath)){
                    return response()->download($filetopath,$zipFileName,$headers);
                }
            }else{
                echo 'dede';
            }
        }else{
            return response()->download( storage_path('app'). '/' . $transaction->factura_url );
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
