<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Gasto;
use App\GastoFijo;

class BalanceController extends Controller
{
    public function flujoGasto(){
    	return view('balance.flujogastos');
    }
    public function saveGasto(Request $r){
    	date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d H:i:s");
    	$data = request()->all();
    	$data['fecha'] = $fechaactual;
    	
    	unset($data['idGasto']);
    	if($r->idGasto==''){
    		$cliente = Gasto::create($data);
    		$res = array('estatus'=>1,'id' => $cliente->id,'mensaje' => 'Se guardo correctamente' );
        	return response()->json($res);
    	}else{
    		$cliente = Gasto::where('id',$r->idGasto)
                ->update($data);
            $res = array('estatus'=>1,'id' => $r->idGasto,'mensaje' => 'Se guardo correctamente');
        	return response()->json($res);
    	}
    }
    public function getGastos(){
    	$gastos = DB::table('gastos')->get()->toArray();
        $gastos = $this->object_to_array($gastos);

        foreach ($gastos as $key => $value) {
        		if($value['estatus']==1){
        			$estatus = '<span class="badge badge-success">Activo</span>';
        			$editar = '<button class="btn btn-sm btn-primary" onclick="editarGasto('.$value['id'].')">Editar</button>';
        			$eliminar = '<button class="btn btn-sm btn-warning" onclick="activardesactivar('.$value['id'].',0)">Inactivar</button>';
        		}else{
        			$estatus = '<span class="badge badge-danger">Inactivo</span>';
        			$editar = '';
        			$eliminar = '<button class="btn btn-sm btn-info" onclick="activardesactivar('.$value['id'].',1)">Activar</button>';
        		}
  				if($value['tipo']==1){
  					$tipo = 'Fijo';
  				}elseif($value['tipo']==2){
  					$tipo = 'Variable';
  				}
  				if($value['periocidad']==1){
  					$periocidad = 'Mensual';
  				}elseif($value['periocidad']==2){
  					$periocidad = 'Anual';
  				}
  				$gastos[$key]['tipo'] = $tipo;
  				$gastos[$key]['periocidad'] = $periocidad;
            	$gastos[$key]['estatus'] = $estatus;
            	$gastos[$key]['acciones'] = $editar.$eliminar;
       	}    

       	$resp = array('data' => $gastos );
		return response()->json($resp);
    }
    public function object_to_array($data) {
        if (is_array($data) || is_object($data)) {
            $result = array();
            foreach ($data as $key => $value) {
                $result[$key] = $this->object_to_array($value);
            }
            return $result;
        }
    return $data;
    }
    public function cambiaEstatusGasto(Request $r){
    	$re = DB::table('gastos')
                ->where('id', $r->id)
                ->update(['estatus' => $r->estatus]);
    	$res = array('estatus' => 1);
        return response()->json($res);
    }
    public function getInfoGasto(Request $r){
    	$gasto = Gasto::find($r->id)->toArray();
    	return response()->json($gasto);
    }
    public function gastosFijos(){
        return view('balance.catalogogastos');
    }
    public function getGastosCatalogo(Request $r){
        $where = array();
        if($r->estatus!='x' && $r->periocidad!=0){
            $gastos = DB::table('catalogo_gastos')
            ->where('estatus','=',$r->estatus)
            ->where('periocidad','=',$r->periocidad)->get()->toArray();
        }
        if($r->estatus=='x' && $r->periocidad!=0){
            $gastos = DB::table('catalogo_gastos')
            ->where('periocidad','=',$r->periocidad)->get()->toArray();
        }
         if($r->estatus!='x' && $r->periocidad==0){
          
            $gastos = DB::table('catalogo_gastos')
            ->where('estatus','=',$r->estatus)->get()->toArray();
        }
         if($r->estatus=='x' && $r->periocidad==0){
            $gastos = DB::table('catalogo_gastos')->get()->toArray();
        }

        $mes = ['3','enero','febrero','marzo','abril','mayo','junio','julio','agosto','septiembre','octubre','noviembre','diciembre'];        
        $gastos = $this->object_to_array($gastos);
        //print_r($gastos);
        //exit();
        foreach ($gastos as $key => $value) {
                if($value['estatus']==1){
                    $estatus = '<span class="badge badge-success">Activo</span>';
                    $editar = '<button class="btn btn-sm btn-primary" onclick="editarGasto('.$value['id'].')">Editar</button>';
                    $eliminar = '<button class="btn btn-sm btn-warning" onclick="activardesactivar('.$value['id'].',0)">Inactivar</button>';
                }else{
                    $estatus = '<span class="badge badge-danger">Inactivo</span>';
                    $editar = '';
                    $eliminar = '<button class="btn btn-sm btn-info" onclick="activardesactivar('.$value['id'].',1)">Activar</button>';
                }
             
                if($value['periocidad']==1){
                    $periocidad = 'Mensual';
                    $gastos[$key]['mes_pago'] = '';
                }elseif($value['periocidad']==2){
                    $periocidad = 'Anual';
                    $gastos[$key]['mes_pago'] = $mes[$value['mes_pago']];
                }

                
                $gastos[$key]['periocidad'] = $periocidad;
                $gastos[$key]['estatus'] = $estatus;
                $gastos[$key]['acciones'] = $editar.$eliminar;
        }    

        $resp = array('data' => $gastos );
        return response()->json($resp);

    }
    public function saveGastoFijo(Request $r){

        $data = request()->all();
        if($r->periocidad==1){
            $data['mes_pago'] = null;
        }else{
            
        }
            //echo $data['mes_pago'];
            //exit();
        unset($data['idGasto']);
        if($r->idGasto==''){
            $cliente = GastoFijo::create($data);
            $res = array('estatus'=>1,'id' => $cliente->id,'mensaje' => 'Se guardo correctamente' );
            return response()->json($res);
        }else{
            $cliente = GastoFijo::where('id',$r->idGasto)
                ->update($data);
            $res = array('estatus'=>1,'id' => $r->idGasto,'mensaje' => 'Se guardo correctamente');
            return response()->json($res);
        }
    }
    public function actualiza_gastos(){
        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d");
        $diaActual =  date("j");
        $mesActual = date("n");
        echo 'Dia='.$diaActual.' Mes='.$mesActual.'<br>';
        $query = 'SELECT * from catalogo_gastos where estatus=1';
        $gastos = DB::select($query);
        $gastos = $this->object_to_array($gastos);
        foreach ($gastos as $key => $value) {
            echo $value['concepto'].'<br>';
            if($value['periocidad']==1){
                if($diaActual==$value['dia_pago']){
                    $data = [
                        'tipo' => 1,
                        'concepto' => $value['concepto'],
                        'importe' => $value['importe'],
                        'periocidad' => $value['periocidad'],
                        'fecha' => $fechaactual
                    ];
                    $cliente = Gasto::create($data);
                }
            }elseif($value['periocidad']==2){
                if($diaActual==$value['dia_pago'] && $mesActual==$value['mes_pago']){
                    $data = [
                        'tipo' => 1,
                        'concepto' => $value['concepto'],
                        'importe' => $value['importe'],
                        'periocidad' => $value['periocidad'],
                        'fecha' => $fechaactual
                    ];
                    $cliente = Gasto::create($data);        
                }
            }else{
 
            }
        }
    }
    
    public function actualiza_obligaciones(){
        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d");
        $fechaactual =  date("Y-m-d",strtotime($fechaactual."+ 1 month")); 
        $diaActual =  date("j");
        $mesActual = date("n");
        $anioActual = date("Y");    
        $mesActual = $mesActual + 1;
        $mes = ['nada','Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'];
        $query = 'SELECT * from v_clientes_obligaciones';
        $obligaciones = DB::select($query);
        $obligaciones = $this->object_to_array($obligaciones);
        foreach ($obligaciones as $key => $value) {
            if($value['meses']==1){
                if($mesActual==1){
                    $comentario = $mes[12].' '.($anioActual - 1);
                    $ano = ($anioActual - 1);
                    $per = 12;
                }else{
                    $comentario = $mes[$mesActual-1].' '.$anioActual;
                    $ano = $anioActual;
                    $per = $mesActual - 1;
                }
                
                DB::table('obligaciones_presentadas')->insert([
                    'id_cliente' => $value['id_cliente'],
                    'id_obligacion' => $value['id_obligacion'],
                    'id_periocidad' => $value['id_periocidad'],
                    'anio' => $ano,
                    'periodo' => $per,
                    'fecha_registro' => $fechaactual,
                    'comentarios' => $comentario
                ]);
            }elseif($value['meses']==2){
                if($mesActual==3){  
                    $comentario = $mes[1].' - '.$mes[2].' '.$anioActual;
                    DB::table('obligaciones_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]); 
                }elseif($mesActual==5){
                    $comentario = $mes[3].' - '.$mes[4].' '.$anioActual;
                    DB::table('obligaciones_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);
                }elseif($mesActual==7){
                    $comentario = $mes[5].' - '.$mes[7].' '.$anioActual;
                    DB::table('obligaciones_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);
                }elseif($mesActual==9){
                    $comentario = $mes[7].' - '.$mes[8].' '.$anioActual;
                    DB::table('obligaciones_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);

                }elseif($mesActual==11){
                    $comentario = $mes[9].' - '.$mes[10].' '.$anioActual;
                    DB::table('obligaciones_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);

                }elseif($mesActual==1){
                    $comentario = $mes[11].' - '.$mes[12].' '.($anioActual - 1);
                    DB::table('obligaciones_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => ($anioActual - 1),
                        'periodo' => 12,
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);
                }else{

                }
            }elseif($value['meses']==3){
                if($mesActual==4){
                    $comentario = $mes[1].' - '.$mes[3].' '.$anioActual;
                    DB::table('obligaciones_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);
                }elseif($mesActual==7){
                    $comentario = $mes[4].' - '.$mes[6].' '.$anioActual;
                    DB::table('obligaciones_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);
                }elseif($mesActual==10){
                    $comentario = $mes[7].' - '.$mes[9].' '.$anioActual;
                    DB::table('obligaciones_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);
                }elseif($mesActual==1){
                    $comentario = $mes[10].' - '.$mes[12].' '.($anioActual-1);
                    DB::table('obligaciones_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => ($anioActual - 1),
                        'periodo' => 12,
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);
                }
            }elseif($value['meses']==12){
                if($mesActual==3){ 
                    $comentario = 'Anual '.($anioActual-1);
                    DB::table('obligaciones_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => ($anioActual - 1),
                        'periodo' => 12,
                        'fecha_registro' => $fechaactual,   
                        'comentarios' => $comentario
                    ]);
                }elseif($mesActual==4){
                    $comentario = 'Anual '.($anioActual-1);
                    DB::table('obligaciones_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => ($anioActual - 1),
                        'periodo' => 12,
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);
                }
            }
        }


    }
    public function actualiaNominas(){
        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d");
        //$fechaactual =  date("Y-m-d",strtotime($fechaactual."+ 1 month")); 
        $diaActual =  date("j");
        $mesActual = date("n");
        $anioActual = date("Y");    
        //$mesActual = $mesActual + 1;
        $mes = ['nada','Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'];
        $query = 'SELECT * from v_clientes_nominas';
        $obligaciones = DB::select($query);
        $obligaciones = $this->object_to_array($obligaciones);
        foreach ($obligaciones as $key => $value) {
            if($value['meses']==1){
               
                $comentario = $mes[$mesActual].' '.$anioActual;
                $ano = $anioActual;
                $per = $mesActual;
                
                DB::table('nominas_presentadas')->insert([
                    'id_cliente' => $value['id_cliente'],
                    'id_obligacion' => $value['id_obligacion'],
                    'id_periocidad' => $value['id_periocidad'],
                    'anio' => $ano,
                    'periodo' => $per,
                    'fecha_registro' => $fechaactual,
                    'comentarios' => $comentario
                ]);
            }elseif ($value['meses']==2) {
                if($mesActual==3){  
                    $comentario = $mes[1].' - '.$mes[2].' '.$anioActual;
                    DB::table('nominas_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]); 
                }elseif($mesActual==5){
                    $comentario = $mes[3].' - '.$mes[4].' '.$anioActual;
                    DB::table('nominas_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);
                }elseif($mesActual==7){
                    $comentario = $mes[5].' - '.$mes[7].' '.$anioActual;
                    DB::table('nominas_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);
                }elseif($mesActual==9){
                    $comentario = $mes[7].' - '.$mes[8].' '.$anioActual;
                    DB::table('nominas_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);

                }elseif($mesActual==11){
                    $comentario = $mes[9].' - '.$mes[10].' '.$anioActual;
                    DB::table('nominas_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => $anioActual,
                        'periodo' => ($mesActual - 1),
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);

                }elseif($mesActual==1){
                    $comentario = $mes[11].' - '.$mes[12].' '.($anioActual - 1);
                    DB::table('nominas_presentadas')->insert([
                        'id_cliente' => $value['id_cliente'],
                        'id_obligacion' => $value['id_obligacion'],
                        'id_periocidad' => $value['id_periocidad'],
                        'anio' => ($anioActual - 1),
                        'periodo' => 12,
                        'fecha_registro' => $fechaactual,
                        'comentarios' => $comentario
                    ]);
                }else{

                }               
            }
        }
    }
}
