<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Obligaciones;
use App\Periocidad;
use App\TipoPersonas;
use App\Cliente;

class CatalogoController extends Controller
{
    public function indexClientes(){

    	return view('catalogos.cliente.gridcliente');
    }
    public function formClientes(){
    	$data['obligaciones'] = Obligaciones::all();
    	$data['periocidad'] = Periocidad::all();
    	$data['tipo_persona'] = TipoPersonas::all();
        $data['obligaciones_nominas'] = DB::table('obligaciones_nominas')->get()->toArray();
    	$data['periocidad_nomina'] = Periocidad::where('meses','<',3)->get();
        //sprint_r($data['periocidad_nomina']);
        //sexit();
    	return view('catalogos.cliente.formcliente')->with('info',$data);
    }	
    public function getObligaciones(Request $r){

    	$data = Obligaciones::whereIn('tipo_persona', array($r->regimen, 3))
               ->get();

    	$res = array('obl' => $data);
        return response()->json($res);
    }
    public function guardaCliente(Request $r){
    	$data = request()->all();
    	unset($data['idCliente']);
    	if($r->idCliente==''){
    		$cliente = Cliente::create($data);
    		$res = array('id' => $cliente->id,'mensaje' => 'Se guardo correctamente' );
        	return response()->json($res);
    	}else{
    		$cliente = Cliente::where('id',$r->idCliente)
                ->update($data);
            $res = array('id' => $r->idCliente,'mensaje' => 'Se guardo correctamente');
        	return response()->json($res);
    	}
    }
    public function guardaObligacion(Request $r){
      
    	$idInsertado = DB::table('clientes_obligaciones')->insertGetId([
    		'id_cliente' => $r->idCliente,
    		'id_obligacion' => $r->obligaciones,
    		'id_periocidad' => $r->periocidad
		]);

		$res = array('id' => $idInsertado,'mensaje' => 'Se guardo correctamente');
        return response()->json($res);
    }
    public function eliminaObligacion(Request $r){
    	$res = DB::table('clientes_obligaciones')->where('id', '=', $r->id)->delete();
    	$res = array('estatus' => 1);
        return response()->json($res);
    }
    public function object_to_array($data) {
        if (is_array($data) || is_object($data)) {
            $result = array();
            foreach ($data as $key => $value) {
                $result[$key] = $this->object_to_array($value);
            }
            return $result;
        }
    return $data;
    }
    public function getClientesGrid(){
    	$clientes = DB::table('v_clientes')->get()->toArray();
        $clientes = $this->object_to_array($clientes);
         //print_r($clientes);
         //exit();
        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d H:i:s");
        foreach ($clientes as $key => $value) {

                if($value['fiel_vence']!=''){
                    $your_datefiel = strtotime($value['fiel_vence']);
                    $datedifffiel =  $your_datefiel - strtotime($fechaactual);
                    $diasFiel = round($datedifffiel / (60 * 60 * 24));

                    if($diasFiel<=15 && $diasFiel > 0){
                        $fielFecha = '<p class="text-warning" title="Faltan '.$diasFiel.' días para vencer">'.$value['fiel_vence'].'</p>';
                    }elseif($diasFiel <= 0){
                        $fielFecha = '<p class="text-danger" title="Fiel vencida">'.$value['fiel_vence'].'</p>';
                    }else{ 
                        $fielFecha = '<p class="text-secondary" title="Faltan '.$diasFiel.' días para vencer">'.$value['fiel_vence'].'</p>';
                    }
                    $clientes[$key]['fiel_vence'] =  $fielFecha ;
                }else{
                    $clientes[$key]['fiel_vence'] = '<p class="text-secondary">'.$value['fiel_vence'].'</p>';
                }


                if($value['sello_vence']!=''){
                    $your_dateCSD = strtotime($value['sello_vence']);
                    $datediffCSD =  $your_dateCSD - strtotime($fechaactual);
                    $diasCSD = round($datediffCSD / (60 * 60 * 24));

                    if($diasCSD<=15 && $diasCSD > 0){
                        $CSDFecha = '<p class="text-warning" title="Faltan '.$diasCSD.' días para vencer">'.$value['sello_vence'].'</p>';
                    }elseif($diasCSD <= 0){
                        $CSDFecha = '<p class="text-danger" title="Fiel vencida">'.$value['sello_vence'].'</p>';
                    }else{ 
                        $CSDFecha = '<p class="text-secondary" title="Faltan '.$diasCSD.' días para vencer">'.$value['sello_vence'].'</p>';
                    }
                    $clientes[$key]['sello_vence'] =  $CSDFecha ;
                }else{
                    $clientes[$key]['sello_vence'] = '<p class="text-secondary">'.$value['sello_vence'].'</p>';
                }



        		if($value['estatus']==1){
        			$estatus = '<span class="badge badge-success">Activo</span>';
        			$editar = '<a href="'.url('catalogos', ['idcliente' => $value['id']]).'" class="btn btn-primary">Editar</a>';
        			$eliminar = '<button class="btn btn-warning" onclick="activardesactivar('.$value['id'].',0)">Inactivar</button>';
        		}else{
        			$estatus = '<span class="badge badge-danger">Inactivo</span>';
        			$editar = '<a href="'.url('catalogos', ['idcliente' => $value['id']]).'" class="btn btn-primary">Editar</a>';
        			$eliminar = '<button class="btn btn-info" onclick="activardesactivar('.$value['id'].',1)">Activar</button>';
        		}
  
            	$clientes[$key]['estatus'] = $estatus;
            	$clientes[$key]['acciones'] = $editar.$eliminar;
       	}    
       	//print_r($clientes);
       	//exit();
       	$resp = array('data' => $clientes );
		//echo json_encode($resp);
		return response()->json($resp);
    }
    public function cambiaEstatusCliente(Request $r){
    	$re = DB::table('clientes')
                ->where('id', $r->id)
                ->update(['estatus' => $r->estatus]);
    	$res = array('estatus' => 1);
        return response()->json($res);
    }
    public function showCliente($idCliente){
        $data['obligaciones'] = Obligaciones::all();
        $data['periocidad'] = Periocidad::all();
        $data['tipo_persona'] = TipoPersonas::all();
        $data['obligaciones_nominas'] = DB::table('obligaciones_nominas')->get()->toArray();
        $data['periocidad_nomina'] = Periocidad::where('meses','<',3)->get();
        $cliente = Cliente::find($idCliente);
   
        $query = 'SELECT * from v_clientes_obligaciones where id_cliente='.$idCliente;
        $clienteObligaciones = DB::select($query);
        $clienteObligaciones = $this->object_to_array($clienteObligaciones);     

        $query = 'SELECT * from v_clientes_nominas where id_cliente='.$idCliente;
        $clienteNominas = DB::select($query);
        $clienteNominas = $this->object_to_array($clienteNominas);                        
        //sdd($clienteObligaciones);
        //sexit();
        return view('catalogos.cliente.formcliente')->with('info',$data)->with('cliente',$cliente)->with('c_obligaciones',$clienteObligaciones)->with('c_nominas',$clienteNominas);
    }
    public function guardaObligacionNomina(Request $r){
        //echo $r->obligaciones;
        $idInsertado = DB::table('clientes_nominas')->insertGetId([
            'id_cliente' => $r->idCliente,
            'id_obligacion' => $r->obligaciones,
            'id_periocidad' => $r->periocidad
        ]);

        $res = array('id' => $idInsertado,'mensaje' => 'Se guardo correctamente');
        return response()->json($res);
    }
    public function eliminaObligacionNomina(Request $r){
        $res = DB::table('clientes_nominas')->where('id', '=', $r->id)->delete();
        $res = array('estatus' => 1);
        return response()->json($res);
    }
}
