<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Factura;
use App\Cliente;
use DB;

class CxcController extends Controller
{
    public function grid(){
		$clientes = Cliente::all();
		$data['clientes'] = $clientes; 
		 $query = 'SELECT * from meses';
        $periodo = DB::select($query);
        $periodo = $this->object_to_array($periodo);
        $data['periodos'] = $periodo;

		return view('cxc.cxcgrid')->with('data',$data);
	}
	public function getCxc(Request $r){	
		$filtro = ' where anio='.$r->anio;

		if($r->cliente!=0){
			$filtro .=' and id_cliente='.$r->cliente;
		}
		if($r->periodo!=0){
			$filtro .=' and mes='.$r->periodo;
		}
		

		$query = 'SELECT * from v_cxc '.$filtro;
        $cxc = DB::select($query);
        $cxc = $this->object_to_array($cxc);
        foreach ($cxc as $key => $value) {
        	$cxc[$key]['SerieFolio'] = $value['serie'].''.$value['folio'];
        	$cxc[$key]['monto'] =  '$'.number_format($value['monto'],2);
        	$cxc[$key]['pagado'] = '$'.number_format($value['pagado'],2);

        	$cxc[$key]['saldo'] = '$'.number_format(($value['monto'] - $value['pagado']),2);
        	if($value['estatus']==1){
        		$estatus='<span class="badge badge-success">Activa</span>';
        	}else{
        		$estatus='<span class="badge badge-danger">Cancelada</span>';
        	}
        	$cxc[$key]['estatus'] = $estatus;
        	$link = '<button class="btn btn-primary" onclick="pagarFact('.$value['id'].','.$value['id_cliente'].')">Pagar</button>';
        	$cxc[$key]['acciones'] =  $link;

        }

        $resp = array('data' => $cxc );
        return response()->json($resp);

	}
	public function object_to_array($data) {
        if (is_array($data) || is_object($data)) {
            $result = array();
            foreach ($data as $key => $value) {
                $result[$key] = $this->object_to_array($value);
            }
            return $result;
        }
    return $data;
    }
    public function cxcCliente($idCliente){
    	//echo $idCliente.'>';
    	$query = 'SELECT * from v_cxc where id_cliente= '.$idCliente;

        $cxc = DB::select($query);
        $cxc = $this->object_to_array($cxc);
        foreach ($cxc as $key => $value) {
        	$cxc[$key]['saldo'] = '$'.number_format(($value['totalFacts'] - $value['pagado']),2);
        	$cxc[$key]['totalFacts'] =  '$'.number_format($value['totalFacts'],2);
        	$cxc[$key]['pagado'] = '$'.number_format($value['pagado'],2);
        	$link = '<a href="'.url('balance/cxc', ['idcliente' => $value['id_cliente']]).'" class="btn btn-primary">Detalle</a>';
        	$cxc[$key]['acciones'] =  $link;

        }

    }
    public function pagosFactura(Request $r){
    	$query = 'SELECT * from facturas_pagos where id_factura= '.$r->idfactura;
        $pagos = DB::select($query);
        $pagos = $this->object_to_array($pagos);

        $cliente =  Cliente::find($r->idCliente);

        $resp = array('data' => $pagos,'cliente' => $cliente->nombre );
        return response()->json($resp);

    }
    public function aplica_pago(Request $r){
    	 //echo $r->obligaciones;
    	date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d");
        $idInsertado = DB::table('facturas_pagos')->insertGetId([
            'id_factura' => $r->idfactura,
            'importe' => $r->importe,
            'fecha' => $fechaactual,
            'estatus' => 1
        ]);

        $res = array('id' => $idInsertado,'mensaje' => 'Se Aplico correctamente');
        return response()->json($res);

    }
    public function elimina_pago(Request $r){
    	$r = DB::table('facturas_pagos')->where('id', '=', $r->id)->delete();
    	$res = array('estatus' => 1);
        return response()->json($res);
    }
}
