@extends('layouts.app')
@section('content')
<div class="row">
  <div class="col-12">
    <nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item" aria-current="page">Catalogos</li>
    <li class="breadcrumb-item active" aria-current="page">Gastos Fijos</li>
  </ol>
</nav>
  </div>
</div> 
<div class="row">
	<div class="col-12">
		<div class="card mb-4">
            <div class="card-body">
               <div class="row">
                  <!--<div class="col-2">
                     <label>Año</label>
                     <input type="text" class="form-control" id="">
                  </div>-->
                  <!--<div class="col-2">
                     <label>Tipo</label>
                    <select id="filTipo" class="form-control" onchange="loadGrid();">
                       <option value="0">-Todos-</option>
                       <option value="1">Fijo</option>
                       <option value="2">Variable</option>
                     </select>
                  </div>-->
                  <div class="col-2">
                     <label>Periocidad</label>
                     <select id="filPeriocidad" class="form-control" onchange="loadGrid();">
                       <option value="0">-Todos-</option>
                       <option value="1">Mensual</option>
                       <option value="2">Anual</option>
                     </select>
                  </div>
                  <div class="col-2">
                     <label>Estatus</label>
                      <select id="filEstatus" class="form-control" onchange="loadGrid();">
                        <option value="x">Todos</option>
                        <option value="1">Activo</option>
                        <option value="2">Cancelado</option>
                      </select>
                  </div>
                  <div class="col-8" align="right">
                     <br>
                    <a class="btn btn-primary" data-toggle="modal" href='#modal-id'>Nuevo Gasto</a>
                  </div>
               </div>
               <div class="row">
               	<div class="col-12">
               		<table class="table" id="gridGastos">
               			<thead>
               				<tr>
                        <th>ID</th>
               					<th>Concepto</th>
               					<th>Importe</th>
               					<th>Periocidad</th>
                        <th>Dia Pago</th>
                        <th>Mes Pago</th>
                        <th>Estatus</th>
               					<th>Acciones</th>
               				</tr>
               			</thead>
               			<tbody>
               			</tbody>
               		</table>
               	</div>
               </div>
            </div>
        </div>
	</div>
</div>

<div class="modal fade" id="modal-id">
   <div class="modal-dialog">
      <div class="modal-content">
         <div class="modal-header bg-dark">
            <h4 class="modal-title">Nuevo Gasto Fijo</h4>
            <input type="hidden" id="idGastoH">
              <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
         </div>
         <div class="modal-body">
         <!--<div class="row">
            <div class="col-12">
               <div class="input-group">
                 <div class="input-group-prepend">
                   <span class="input-group-text" id="">Tipo Gasto</span>
                 </div>
                 <select id="tipoGasto" class="form-control">
                   <option value="1">Fijo</option>
                   <option value="2">Variable</option>
                 </select>
               </div>
            </div>
         </div>-->
         <div class="row">
            <div class="col-12">
                             <div class="input-group">
                 <div class="input-group-prepend">
                   <span class="input-group-text" id="">Concepto</span>
                 </div>
                 <input type="text" id="concepto" class="form-control">
               </div>
            </div>
          </div>
          <br>
          <div class="row">
              <div class="col-12">
                <div class="input-group">
                 <div class="input-group-prepend">
                   <span class="input-group-text">Periocidad</span>
                 </div>
                 <select id="periocidad" class="form-control" onchange="muestraInput();">
                   <option value="1">Mensual</option>
                   <option value="2">Anual</option>
                 </select>
               </div>
              </div>
          </div>
          <br>
          <div class="row" id="selMensual">
            <div class="col-12">
              <div class="input-group">
                 <div class="input-group-prepend">
                   <span class="input-group-text" id="">Dia Pago</span>
                 </div>
                 <input type="text" id="dia_pago" class="form-control">
              </div>
            </div>
          </div>
          <br>
          <div class="row" id="selAnual" style="display:none;">
            <div class="col-12">
              <div class="input-group">
                 <div class="input-group-prepend">
                   <span class="input-group-text" id="">Mes Pago</span>
                 </div>
                 <select id="mesPago" class="form-control">
                   <option value="1">Enero</option>
                   <option value="2">Febrero</option>
                   <option value="3">Marzo</option>
                   <option value="4">Abril</option>
                   <option value="5">Mayo</option>
                   <option value="6">Junio</option>
                   <option value="7">Julio</option>
                   <option value="8">Agosto</option>
                   <option value="9">Septiembre</option>
                   <option value="10">Octubre</option>
                   <option value="11">Noviembre</option>
                   <option value="12">Diciembre</option>
                 </select>
              </div>
            </div>
          </div>
          <br>
            <div class="row">
              <div class="col-12">
                <div class="input-group">
                 <div class="input-group-prepend">
                   <span class="input-group-text" id="">Importe $</span>
                 </div>
                 <input type="number" id="importe" class="form-control">
               </div>
              </div>
            </div>
            <br>  
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
            <button type="button" class="btn btn-primary" onclick="saveGastoFijo();">Guardar</button>
         </div>
      </div>
   </div>
</div>
<script>
     $(document).ready(function() {
    $.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }

}); 
      loadGrid();
      $('#fecha_pago').datepicker();
   });
    function loadGrid(){
  
       //$('#').DataTable();
      $('#gridGastos').dataTable().fnDestroy();
      $('#gridGastos').DataTable( {
           //processing: true,
           responsive: true,
           //serverSide: true,
           ajax: {
               url: "get_gastos_catalogos",
               type: "POST",
               //type : 'post'
               data : { 
                  periocidad : $('#filPeriocidad').val(),
                  estatus : $('#filEstatus').val(),
                },
           },
           columns: [
               { data: "id" },
               { data: "concepto" },
               { data: "importe" },
               { data: "periocidad" },
               { data: "dia_pago"},
               { data: "mes_pago"},
               { data: "estatus" },
               { data: "acciones" },
           ],
           order: [0,"desc"]
      } );
      
   }
   function muestraInput(){
      var tipo = $('#periocidad').val()

      if(tipo==1){
        //$('#selMensual').show()
        $('#selAnual').hide()
      }else{
        $('#selAnual').show()
        //$('#selMensual').hide()
      }
   }
     function saveGastoFijo(){ 
      var fecha_pago = $('#fecha_pago').val()
      var dia_pago = $('#dia_pago').val()
      var mes_pago = $('#mesPago').val()
      var concepto = $('#concepto').val();
      var importe = $('#importe').val()
      var periodo = $('#periocidad').val()
      var idGasto = $('#idGastoH').val()

      if(concepto==''){
        alert('Debes de agregar un concepto');
        return false;
      }
      if(importe=='' || importe < 0){
        alert('El importe no es valido')
        return false;
      }
  
      $.ajax({
        url: 'save_gasto_fijo',
        type: 'POST',
        dataType: 'json',
        data: {
          concepto : concepto,
          importe : importe,
          periocidad : periodo,
          dia_pago : dia_pago,
          mes_pago : mes_pago,
          idGasto : idGasto,
        },
      })
      .done(function(resp) {
        console.log(resp);
        if(resp.estatus==1){
          alert('Se guardo con exito');
          $('#modal-id').modal('hide')
          //loadGrid();
        }else{
          alert('Ocurrio un erro al guardar el gasto.')
          $('#modal-id').modal('hide')
        }
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
      
     }
    function editarGasto(id){
      $.ajax({
        url: 'get_info_gasto',
        type: 'POST',
        dataType: 'json',
        data: {id: id},
      })
      .done(function(resp) {
        console.log(resp);
        var tipo = $('#tipoGasto').val(resp.tipo)
        var concepto = $('#concepto').val(resp.concepto);
        var importe = $('#importe').val(resp.importe)
        var periodo = $('#periocidad').val(resp.periocidad)
        var idGasto = $('#idGastoH').val(id)
        $('#modal-id').modal('show')
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
      
    }
    function activardesactivar(id,estatus){
      var txt;
      var r = confirm("Deseas cambiar estatus del gasto?");
      if (r == true) {
        $.ajax({
          url: 'cambia_estatus_gasto',
          type: 'POST',
          dataType: 'json',
          data: {
            id: id,
            estatus: estatus
          },
        })
        .done(function(resp) {
          console.log("success");
          if(resp.estatus==1){
            alert('Se cambio con exito');
            loadGrid();
          }
        })
        .fail(function() {
          console.log("error");
        })
        .always(function() {
          console.log("complete");
        });
        
      } else {
        return false;
      }
   }
</script>

@endsection