@extends('layouts.app')
@section('content')
<div class="row">
  <div class="col-12">
    <nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item" aria-current="page">Catalogos</li>
    <li class="breadcrumb-item" aria-current="page"><a href="{{ url('catalogos/clientes') }}">Clientes</a></li>

    @if(isset($cliente))
       <li class="breadcrumb-item active" aria-current="page">{{ $cliente->nombre }}</li>
   @else
      <li class="breadcrumb-item active" aria-current="page">Nuevo Cliente</li>
   @endif
  </ol>
</nav>
  </div>
</div>
<div class="row">
	<div class="col-12">
		<div class="card mb-4">
            <div class="card-header">
               Datos Cliente
            </div>
            <div class="card-body">
               <ul class="nav nav-tabs" id="myTab" role="tablist">
                 <li class="nav-item">
                   <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Datos Cliente</a>
                 </li>
                 <li class="nav-item" id="obligacionesTab" style="display:block;">
                   <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Obligaciones Fiscales</a>
                 </li>
                 <li class="nav-item" id="obligacionesNominaTab" style="display:block;">
                   <a class="nav-link" id="profile2-tab" data-toggle="tab" href="#profile2" role="tab" aria-controls="profile2" aria-selected="false">Obligaciones Nominales</a>
                 </li>
               </ul>
               <div class="tab-content" id="myTabContent">
                 <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                        <div class="row">
                           <div class="col-12">
                              <label>Datos Generales</label>
                           </div>
                        </div>
                        <input type="hidden" id="idCliente" 
                        @isset ($cliente)
                            value="{{ $cliente->id }}"
                        @endisset>
                        <div class="row">
                           <div class="col-4">
                              <label>RFC</label>
                              <input type="text" class="form-control input-sm" id="rfc"
                              @isset ($cliente)
                                 value="{{ $cliente->rfc }}"
                               @endisset>
                           </div>
                           <div class="col-4">
                              <label>Nombre</label>
                              <input type="text" class="form-control input-sm" id="nombre"
                               @isset ($cliente)
                                 value="{{ $cliente->nombre }}"
                               @endisset>
                           </div>
                           <div class="col-4">
                              <label>Email</label>
                              <input type="text" class="form-control input-sm" id="email"
                              @isset ($cliente)
                                 value="{{ $cliente->email }}"
                               @endisset>
                           </div>
                        </div>
                        <div class="row">
                           <div class="col-4">
                              <label>Telefono</label>
                              <input type="text" class="form-control input-sm" id="telefono"
                              @isset ($cliente)
                                 value="{{ $cliente->telefono }}"
                               @endisset>
                           </div>
                           <div class="col-8">
                              <label>Direccion</label>
                              <input type="text" class="form-control input-sm" id="direccion"
                              @isset ($cliente)
                                 value="{{ $cliente->direccion }}"
                               @endisset>
                           </div>
                        </div>
                        <div class="row">
                           <div class="col-4">
                              <label>Regimen Fiscal</label>
                              <select id="regimen" class="form-control" onchange="getObligaciones();">
                                 <option value="0">-Selecciona-</option>
                                 @foreach ($info['tipo_persona'] as  $o)
                                    @isset ($cliente)
                                       @if($cliente->regimen == $o->id)
                                 <option value="{{ $o->id }}" selected>{{ $o->persona }}</option>
                                       @else
                                 <option value="{{ $o->id }}">{{ $o->persona }}</option>
                                       @endif
                                    @endisset>
                                 @endforeach
                              </select>
                           </div>
                        </div>
                        <div class="row">
                           <label>Claves de Acceso</label>
                        </div>
                        <div class="row">
                           <div class="col-3">
                              <label>CIEC</label>
                              <input type="text" class="form-control input-sm" id="ciec"
                              @isset ($cliente)
                                 value="{{ $cliente->ciec }}"
                               @endisset>
                           </div>
                           <div class="col-3">
                              <label>FIEL</label>
                              <input type="text" class="form-control input-sm" id="fiel"
                                @isset ($cliente)
                                 value="{{ $cliente->fiel }}"
                               @endisset>
                           </div>
                           <div class="col-3">
                              <label>CSD</label>
                              <input type="text" class="form-control input-sm" id="csd"
                                @isset ($cliente)
                                 value="{{ $cliente->csd }}"
                               @endisset>
                           </div>
                            <div class="col-3">
                              <label>IMSS</label>
                              <input type="text" class="form-control input-sm" id="imss"
                                @isset ($cliente)
                                 value="{{ $cliente->imss }}"
                               @endisset>
                           </div>   
                        </div>
                        <div class="row">
                           <div class="col-3">
                              <label>ISN</label>
                              <input type="text" class="form-control input-sm" id="isn"
                                @isset ($cliente)
                                 value="{{ $cliente->isn }}"
                               @endisset>
                           </div>
                           <div class="col-3">
                              <label>IDSE</label>
                              <input type="text" class="form-control input-sm" id="idse"
                                @isset ($cliente)
                                 value="{{ $cliente->idse }}"
                               @endisset>
                           </div>
                           <div class="col-3">
                              <label>Vencimiento FIEL</label>
                              <input type="text" class="form-control input-sm datepicker" id="fiel_vence"
                                @isset ($cliente)
                                 value="{{ $cliente->fiel_vence }}"
                               @endisset>
                           </div>
                           <div class="col-3">
                              <label>Vencimiento CSD</label>
                              <input type="text" class="form-control input-sm datepicker" id="sello_vence"
                              @isset ($cliente)
                                 value="{{ $cliente->sello_vence   }}"
                               @endisset>
                           </div>
           
                        </div>
                        <div class="row">
                           <div class="col-12" align="right">
                              <button class="btn btn-primary" onclick="guardarCliente();">Guardar</button>
                           </div>
                        </div>
                 </div>
                 <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                        <div class="row">
                           <label>Obligaciones Fiscales</label>
                        </div>

                        <div class="row">
                           <div class="col-4">
                              <label>Añadir</label>
                              <select id="obligaciones" class="form-control">
                                 <option value="0">-Selecciona-</option>
                                 @foreach ($info['obligaciones'] as  $o)
                                    <option value="{{ $o->id }}" disp="{{ $o->nombre_obligacion }}">{{ $o->nombre_obligacion }}</option>
                                 @endforeach
                              </select>
                           </div>
                           <div class="col-4">
                              <label>Periocidad</label>
                              <select id="periocidadInput" class="form-control">
                                 <option value="0">-Selecciona-</option>
                                 @foreach ($info['periocidad'] as  $o)
                                    <option value="{{ $o->id }}" disp="{{ $o->nombre }}">{{ $o->nombre }}</option>
                                 @endforeach
                              </select>
                           </div>
                           <div class="col-2">
                              <br>
                              <button class="btn btn-primary" onclick="agregaObligacion();">Agregar</button>
                           </div>
                        </div>
                        <br>
                        <div class="row">
                           <div class="col-12">
                              <table class="table table-bordered table-hover" id="tableObligaciones">
                                 <thead>
                                    <tr>
                                       <th>Obligacion</th>
                                       <th>Periocidad</th>
                                       <th><div align="center">Acciones</div></th>
                                    </tr>
                                 </thead>
                                 <tbody id="bodyObligaciones">
                                    @isset ($c_obligaciones)
                                       @foreach ($c_obligaciones as  $obl)
                                       <tr id="obli_{{ $obl['id'] }}">
                                          <td>{{ $obl['nombre_obligacion'] }}</td>
                                          <td>{{ $obl['periocidad'] }}</td>
                                          <td>
                                             <div align="center"><button class="btn btn-danger" onclick="eliminaObligacion({{ $obl['id'] }})">X</button></div>
                                          </td>
                                       </tr>   
                                       @endforeach
                                    @endisset
                                  
                                 </tbody>
                              </table>
                           </div>
                        </div>
                 </div>
                 <div class="tab-pane fade" id="profile2" role="tabpanel" aria-labelledby="profile2-tab">
                    <div class="row">
                       <div class="col-4">
                          <label>Nominas Obligaciones</label>
                          <select class="form-control" id="nomina">
                             @foreach ($info['obligaciones_nominas'] as $o)
                                <option value="{{ $o->id }}" disp="{{ $o->obligacion }}">{{ $o->obligacion }}</option>
                             @endforeach
                          </select>
                       </div>
                        <div class="col-4">
                          <label>Periocidad</label>
                          <select class="form-control" id="perciocidadNominas">
                             @foreach ($info['periocidad_nomina'] as $o)
                                <option value="{{ $o->id }}" disp="{{ $o->nombre }}">{{ $o->nombre }}</option>
                             @endforeach
                          </select>
                       </div>
                       <div class="col-2">
                          <br>
                          <button class="btn btn-primary" onclick="agregaNomina();">Agregar</button>
                       </div>
                    </div>
                    <br>
                    <div class="row">
                       <div class="col-12">
                          <table class="table table-bordered table-inverse table-hover">
                             <thead>
                                <tr>
                                   <th>Obligacions</th>
                                   <th>Periocidad</th>
                                   <th>Acciones</th>
                                </tr>
                             </thead>
                             <tbody id="bodyObligacionesN">
                                    @isset ($c_nominas)
                                       @foreach ($c_nominas as  $obl)
                                       <tr id="obli_{{ $obl['id'] }}">
                                          <td>{{ $obl['nombre_obligacion'] }}</td>
                                          <td>{{ $obl['periocidad'] }}</td>
                                          <td>
                                             <div align="center"><button class="btn btn-danger" onclick="eliminaObligacionNomina({{ $obl['id'] }})">X</button></div>
                                          </td>
                                       </tr>   
                                       @endforeach
                                    @endisset
                             </tbody>
                          </table>
                       </div>
                    </div>
                 </div>
               </div>





            </div>
        </div>
	</div>
</div>

<div class="modal fade" id="cargando">
   <div class="modal-dialog">
      <div class="modal-content">
         <div class="modal-header">
            <h4 class="modal-title">Cargando</h4>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-12 align-items-center">
                  <div align="center">
                     <img src="{{ asset('img/loading.gif') }}" width="400">
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<script>
  
   $(document).ready(function() {
      $('.datepicker').datepicker({
         format: 'yyyy-mm-dd',
      });

   });
   function getObligaciones(){
      $.ajax({
         url: 'get_obligaciones',
         type: 'POST',
         dataType: 'json',
         data: {regimen: $('#regimen').val()},
      })
      .done(function(resp) {
         console.log(resp);
         $('#obligaciones').empty()
         $.each(resp.obl, function(index, val) {
             $('#obligaciones').append('<option value="'+val.id+'">'+val.nombre_obligacion+'</option>')
         });
      })
      .fail(function() {
         console.log("error");
      })
      .always(function() {
         console.log("complete");
      });
      
   }
   function guardarCliente(){
      var idCliente = $('#idCliente').val()
      var rfc = $('#rfc').val()
      var nombre = $('#nombre').val()
      var email = $('#email').val()
      var telefono = $('#telefono').val()
      var direccion = $('#direccion').val()
      var regimen = $('#regimen').val()
      var ciec = $('#ciec').val()
      var fiel = $('#fiel').val()
      var csd = $('#csd').val()
      var imss = $('#imss').val()
      var isn = $('#isn').val()
      var idse = $('#idse').val()
      var fiel_vence = $('#fiel_vence').val()
      var sello_vence = $('#sello_vence').val()
      //$('#cargando').modal()
      $.ajax({
         url: 'guarda_cliente',
         type: 'POST',
         dataType: 'json',
         data: {
            idCliente: idCliente,
            rfc : rfc,
            nombre : nombre,
            email : email,
            telefono : telefono,
            direccion : direccion,
            regimen : regimen,
            ciec : ciec,
            fiel : fiel,
            csd : csd,
            imss : imss,
            isn : isn,
            idse : idse,
            fiel_vence : fiel_vence,
            sello_vence : sello_vence,
         },
      })
      .done(function(resp) {
         console.log(resp);
         if(resp.id!='0'){
            //$('#cargando').modal('hide')
            alert(resp.mensaje)
            //$('#idCliente').val(resp.id);
            //$('#obligacionesTab').show();
            
            //location.href = {{ url('catalogos/clientes') }}
         }
      })
      .fail(function() {
         console.log("error");
      })
      .always(function() {
         console.log("complete");
      });
      
   }
   function agregaObligacion(){
      var periocidad = $('#periocidadInput').val();
      var periocidadDisplay = $('#periocidadInput > option:selected').attr('disp');
      var obligaciones = $('#obligaciones').val();
      var obligacionesDisplay = $('#obligaciones > option:selected').attr('disp');
      var idCliente = $('#idCliente').val();
      
      if(idCliente==''){
         alert('Error');
         return false;
      }
      $.ajax({
         url: 'guarda_obligacion',
         type: 'POST',
         dataType: 'json',
         data: {
            periocidad: periocidad,
            obligaciones: obligaciones,
            idCliente: idCliente,
         },
      })
      .done(function(resp) {
         console.log(resp);
         if(resp.id!=0){
            html = '<tr id="obli_'+resp.id+'">';
            html +='<td>'+obligacionesDisplay+'</td>';
            html +='<td>'+periocidadDisplay+'</td>';
            html +='<td><div align="center"><button class="btn btn-danger" onclick="eliminaObligacion('+resp.id+')">X</button></div></td>';
            html +='</tr>';

            $('#bodyObligaciones').append(html)
         }
      })
      .fail(function() {
         console.log("error");
      })
      .always(function() {
         console.log("complete");
      });
      
   }
   function eliminaObligacion(id){
      var txt;
      var r = confirm("Deseas elminar la obligacion?");
      if (r == true) {
        $.ajax({
           url: 'elimina_obligacion',
           type: 'POST',
           dataType: 'json',
           data: {id: id},
        })
        .done(function(resp) {
           console.log(resp);
           if(resp.estatus==1){
               alert('Se elimino correctamente');
               $('#obli_'+id).remove();
           }
        })
        .fail(function() {
           console.log("error");
        })
        .always(function() {
           console.log("complete");
        });
        
      } else {
        return false;
      }
   }
   function agregaNomina(){
      var idCliente = $('#idCliente').val();
      var obli = $('#nomina').val()
      var obligacionesDisplay = $('#nomina > option:selected').attr('disp');
      var periocidad = $('#perciocidadNominas').val()
      var periocidadDisplay = $('#perciocidadNominas > option:selected').attr('disp');
      //alert(obligacionesDisplay)
      //return false;
      if(idCliente==''){
         alert('Error');
         return false;
      }
      $.ajax({
         url: 'guarda_obligacion_nomina',
         type: 'POST',
         dataType: 'json',
         data: {
            periocidad: periocidad,
            obligaciones: obli,
            idCliente: idCliente,
         },
      })
      .done(function(resp) {
         console.log(resp);
         if(resp.id!=0){
            html = '<tr id="obliN_'+resp.id+'">';
            html +='<td>'+obligacionesDisplay+'</td>';
            html +='<td>'+periocidadDisplay+'</td>';
            html +='<td><div align="center"><button class="btn btn-danger" onclick="eliminaObligacionNomina('+resp.id+')">X</button></div></td>';
            html +='</tr>';

            $('#bodyObligacionesN').append(html)
         }
      })
      .fail(function() {
         console.log("error");
      })
      .always(function() {
         console.log("complete");
      });
   }
      function eliminaObligacion(id){
      var txt;
      var r = confirm("Deseas elminar la obligacion?");
      if (r == true) {
        $.ajax({
           url: 'elimina_obligacion',
           type: 'POST',
           dataType: 'json',
           data: {id: id},
        })
        .done(function(resp) {
           console.log(resp);
           if(resp.estatus==1){
               alert('Se elimino correctamente');
               $('#obli_'+id).remove();
           }
        })
        .fail(function() {
           console.log("error");
        })
        .always(function() {
           console.log("complete");
        });
        
      } else {
        return false;
      }
   }   
   function eliminaObligacionNomina(id){
      var txt;
      var r = confirm("Deseas elminar la obligacion?");
      if (r == true) {
        $.ajax({
           url: 'elimina_obligacion_nomina',
           type: 'POST',
           dataType: 'json',
           data: {id: id},
        })
        .done(function(resp) {
           console.log(resp);
           if(resp.estatus==1){
               alert('Se elimino correctamente');
               $('#obliN_'+id).remove();
           }
        })
        .fail(function() {
           console.log("error");
        })
        .always(function() {
           console.log("complete");
        });
        
      } else {
        return false;
      }
   }
</script>

@endsection