@extends('layouts.app')
@section('content')
<div class="row">
  <div class="col-12">
    <nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item" aria-current="page">Gestion Contable</li>
    <li class="breadcrumb-item active" aria-current="page">{{ $data['tipo'] }}</li>
  </ol>
</nav>
  </div>
</div> 
<div class="row">
	<div class="col-12">
		<div class="card">
            <input type="hidden" id="tipoHide" value="{{ $data['id_tipo'] }}">
            <div class="card-body">
              <div class="row">
                <div class="col-3">
                  <label>Año</label>
                  <select id="anio" class="form-control" onchange="loadGrid();">
                    <option value="2020">2020</option>
                    <option value="2021" selected>2021</option>
                  </select>
                </div>
                @if ($data['id_tipo'] != 4)
                <div class="col-3">
                  <label>Periodo</label>
                  <select id="periodo" class="form-control" onchange="loadGrid();"> 
                  @foreach ($data['periodos'] as $peri)
                      <option value="{{ $peri['mes'] }}">{{ $peri['periodo'] }}</option>
                  @endforeach
                  </select>
                </div>
        
                @endif
                <div class="col-3"></div>
                <div class="col-3" align="right">
                  <br>
                  <!--<div class="progress">
                    <div id="barTotal" class="progress-bar progress-bar-striped bg-success" role="progressbar"  style="width: 16.7%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>


                  </div>-->
                  <div class="progress" style="height: 20px;">
                     <div id="barTotal" class="progress-bar progress-bar-striped bg-success label-porcentaje_total" role="progressbar" style="width: 25%;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">25%</div>
                  </div>
                </div>
                <!--<div class="col-1">
                  <h3 id="label-porcentaje_total"></h3>
                </div>-->
              </div>
               <div class="row">
               	<div class="col-12">
               		<table class="table table-inverse" id="gridClientes">
               			<thead>
               				<tr>
               					<!--<th>ID</th>-->
               					<th>RFC</th>
               					<th>Cliente</th>
               					<th>CIEC</th>
               					<th>Fiel</th>
               					<th>CSD</th>
               					<!--<th>R.Patronal</th>-->
                        <th>ISN</th>
                        <th>IDSE</th>
                        <!--<th>Sipare</th>-->
                        <th>Estatus</th>
                        <th>Presentar</th>
                        <th align="center">Contabilidad</th>
               				</tr>
               			</thead>
               			<tbody>
               		
               			</tbody>
               		</table>
               	</div>
               </div>
            </div>
        </div>
	</div>
</div>


<div class="modal fade" id="modalObligaciones">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-info">
        <h4 class="modal-title">Obligaciones</h4>
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-12">
            <h5 id="label-cliente"></h5>
          </div>
        </div>
        <div class="row">
          <div class="col-12">
                      <!--<div class="progress">
  <div id="barCliente" class="progress-bar progress-bar-striped bg-success" role="progressbar"  style="width: 16.7%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
</div>-->
            <div class="progress" style="height: 20px;">
                <div id="barCliente" class="progress-bar progress-bar-striped bg-success label-porcentaje" role="progressbar" style="width: 25%;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">25%</div>
            </div>
          </div>
          <!--<div class="col-2" align="center">
            <h5 id="label-porcentaje">10%</h5>
          </div>-->
        </div>  
        <br>
        <div class="row">
          <div class="col-12">
            <table class="table table-bordered table-inverse table-hover">
              <thead>
                <tr>
                  <th>Obligacion</th>
                  <th>Comentarios</th>
                  <th>Estatus</th>
                  <th>Revision</th>
                  <th>Acciones</th>
                </tr>
              </thead>
              <tbody id="bodyTable">

              </tbody>
            </table>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" style="display:none;" id="btnPresentar" onclick="presentar();">Presentar</button>
      </div>
    </div>
  </div>
</div>


 
 <div class="modal fade" id="modalLoading">
   <div class="modal-dialog">
     <div class="modal-content">
       <div class="modal-header">
         <h4 class="modal-title">Presentando</h4>
       </div>
       <div class="modal-body">
          <div class="row">
            <div class="col-12">
              <h5>Presentando...</h5>
            </div>
          </div>
          <div class="row">
            <div class="col-12"></div>
          </div>
       </div>
     </div>
   </div>
 </div>

<script>
   $(document).ready(function() {
    $.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
}); 
      loadGrid();
     
   });
  function loadGrid(){
       getPercet();
       //$('#').DataTable();
      $('#gridClientes').dataTable().fnDestroy();
      $('#gridClientes').DataTable( {
           processing: true,
           responsive: true,
           //serverSide: true,
           ajax: {
               url: "get_obligaciones_presentadas",
               type: "POST",
               data: {
                  tipo : $('#tipoHide').val(),
                  anio : $('#anio').val(),
                  periodo : $('#periodo').val()
               }
           },
           columns: [
               //{ data: "id" },
               { data: "rfc" },
               { data: "nombre" },
               { data: "ciec" },
               { data: "fiel" },
               { data: "csd" },
               { data: "isn" },
               { data: 'idse'},
               { data: 'estatus'},
               { data: "acciones" },
               { data: "conta" },

           ],
           order: [[0,"desc"]]
       } );
      
   }
  function getPercet(){
    $.ajax({
      url: 'get_percent_balance',
      type: 'POST',
      dataType: 'json',
      data: {
          tipo : $('#tipoHide').val(),
          anio : $('#anio').val(),
          periodo : $('#periodo').val()
      },
    })
    .done(function(resp) {
      console.log(resp);
      $('#barTotal').attr('style', 'width:'+resp.porcentaje+'%');
      $('.label-porcentaje_total').html(resp.porcentaje.toFixed(2)+'%')
    })
    .fail(function() {
      console.log("error");
    })
    .always(function() {
      console.log("complete");
    });
    
   }
   function verDetalle(id_cliente,id_periocidad,anio,periodo){
        $.ajax({
          url: 'get_obligaciones_presentadas_cliente',
          type: 'POST',
          dataType: 'json',
          data: {
            id_cliente: id_cliente,
            id_periocidad: id_periocidad,
            anio: anio,
            periodo: periodo
          },
        })
        .done(function(resp) {
          console.log(resp);
          $('#bodyTable').empty()
          $('.label-porcentaje').empty()
          $('#btnPresentar').hide()
          html = '';
          cont = 0;
          presentadas = 0;
          $.each(resp.data, function(index, val) {
            html += '<tr>';
            html += '<td>'+val.nombre_obligacion+'</td>';
            html += '<td>'+val.comentarios+'</td>';
            html += '<td>'+val.revisada+'</td>';
            html += '<td>'+val.estatus+'</td>';
            html += '<td>'+val.acciones+'</td>';
            html +='</tr>'
            if(val.estatus_number==2){
              presentadas++
            }
            cont ++
          });
           
          porcentaje = (presentadas * 100) / cont

          $('#bodyTable').append(html)
          $('.label-porcentaje').html(porcentaje.toFixed(2)+'%')
          $('#label-cliente').html(resp.cliente)
          $('#barCliente').attr('style', 'width:'+porcentaje+'%');
          $('#modalObligaciones').modal()
        })
        .fail(function() {
          console.log("error");
        })
        .always(function() {
          console.log("complete");
        });
        
   }
   function revisaChecks(){
    cont=0;
    $("input[type=checkbox]:checked").each(function(){
      cont++
      //alert($(this).val());
    });
    if(cont > 0){
      $('#btnPresentar').show()
    }else{
      $('#btnPresentar').hide()
    }
   }
   function presentar(){
      //$('#modalLoading').modal()
      var obliga = [];
      $("input[type=checkbox]:checked").each(function(){
        obliga.push($(this).val())
      });
      $.ajax({
        url: 'presentar_obligaciones',
        type: 'POST',
        dataType: 'json',
        data: {cadena: obliga},
      })
      .done(function(resp) {
        console.log(resp);
        if(resp.estatus==1){
          //$('#modalLoading').modal('hide')
          $('#modalObligaciones').modal('hide')
          alert('Se Actualizaron Correctamente');
          loadGrid();
        }
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
      
   }
   function desPresentar(id){
      var r = confirm("Estas seguro de cancelar la prentacion de la obligacion?");
      if (r == true) {
        $.ajax({
          url: 'des_presentar_obligaciones',
          type: 'POST',
          dataType: 'json',
          data: {id: id},
        })
        .done(function(resp) {
          console.log("success");
          if(resp.estatus==1){
          //$('#modalLoading').modal('hide')
          $('#modalObligaciones').modal('hide')
          alert('Se Actualizaron Correctamente');
          loadGrid();
          }
        })
        .fail(function() {
          console.log("error");
        })
        .always(function() {
          console.log("complete");
        });
        
      }else{
        return false;
      } 
   }


</script>
@endsection