<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*Route::get('/', function () {
    return view('home');
});*/

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');
Route::get('/home2', 'HomeController@prueba')->name('prueba');

Route::get('catalogos/clientes', 'CatalogoController@indexClientes');
Route::get('catalogos/altaclientes', 'CatalogoController@formClientes');
Route::get('catalogos/{idcliente}', 'CatalogoController@showCliente');
Route::post('catalogos/get_obligaciones', 'CatalogoController@getObligaciones');
Route::post('catalogos/guarda_cliente', 'CatalogoController@guardaCliente');
Route::post('catalogos/guarda_obligacion', 'CatalogoController@guardaObligacion');
Route::post('catalogos/guarda_obligacion_nomina', 'CatalogoController@guardaObligacionNomina');
Route::post('catalogos/elimina_obligacion', 'CatalogoController@eliminaObligacion');
Route::post('catalogos/elimina_obligacion_nomina', 'CatalogoController@eliminaObligacionNomina');
Route::post('catalogos/get_clientes', 'CatalogoController@getClientesGrid');
Route::post('catalogos/cambia_estatus_cliente', 'CatalogoController@cambiaEstatusCliente');


Route::get('config/empresa', 'ConfiguracionController@index');
Route::post('config/guarda_empresa', 'ConfiguracionController@guarda_empresa');

Route::get('config/usuarios', 'ConfiguracionController@usuarios');

Route::get('balance/flujogasto', 'BalanceController@flujoGasto');
Route::post('balance/save_gasto', 'BalanceController@saveGasto');
Route::post('balance/get_gastos', 'BalanceController@getGastos');
Route::post('balance/cambia_estatus_gasto', 'BalanceController@cambiaEstatusGasto');
Route::post('balance/get_info_gasto', 'BalanceController@getInfoGasto');
Route::get('balance/catalogo_gastos', 'BalanceController@gastosFijos');
Route::post('balance/get_gastos_catalogos', 'BalanceController@getGastosCatalogo');
Route::post('balance/save_gasto_fijo', 'BalanceController@saveGastoFijo');
Route::get('balance/actualiza_gastos', 'BalanceController@actualiza_gastos');
Route::get('balance/actualiza_obligaciones', 'BalanceController@actualiza_obligaciones');


Route::get('almacen/digital', 'AlmacenDigitalController@grid');
Route::get('almacen/grid', 'AlmacenDigitalController@indexAlmacen');
Route::get('almacen/verifica', 'AlmacenDigitalController@verificaSolicitud');
Route::post('almacen/getxmls', 'AlmacenDigitalController@getXMLs');
Route::post('almacen/verifica_solicitud_datos', 'AlmacenDigitalController@verifica_solicitud_datos');
Route::post('almacen/verifica_solicitud_xml', 'AlmacenDigitalController@verifica_solicitud_xml');
Route::post('almacen/get_facturas_grid', 'AlmacenDigitalController@getFacturasGrid');

Route::get('gestion/gestion_contable/{tipo}', 'GestionController@indexGestion');
Route::get('gestion/gestion_nomina/{tipo}', 'GestionController@indexNomina');

Route::post('gestion/gestion_contable/get_obligaciones_presentadas', 'GestionController@get_obligaciones_presentadas');
Route::post('gestion/gestion_contable/get_obligaciones_presentadas_cliente', 'GestionController@get_obligaciones_presentadas_cliente');
Route::post('gestion/gestion_contable/presentar_obligaciones', 'GestionController@presentarObligaciones');
Route::post('gestion/gestion_contable/get_percent_balance', 'GestionController@getPercentBalance');
Route::post('gestion/gestion_contable/des_presentar_obligaciones', 'GestionController@desPresentarObligaciones');


Route::post('gestion/get_periodos', 'GestionController@getPeriodosNomina');
Route::post('gestion/gestion_nomina/get_nominas_presentadas', 'GestionController@get_nominas_presentadas');
Route::post('gestion/gestion_nomina/presentar_nominas_individual', 'GestionController@presentarNominaIndividual');
Route::post('gestion/gestion_nomina/despresentar_nomina', 'GestionController@desPresentarNomina');
Route::post('gestion/gestion_nomina/presentar_nominas', 'GestionController@presentarNominas');
Route::post('gestion/gestion_nomina/get_percent_balance_nominas', 'GestionController@getPercentNominas');
Route::post('gestion/get_nominas_presentadas_cliente', 'GestionController@get_nominas_presentadas_cliente');

Route::get('gestion/gestion_diotelectronica/{tipo}', 'GestionController@indexDIOTELCE');
Route::post('gestion/gestion_diotelectronica/get_diot_presentadas', 'GestionController@get_diot_presentada');
Route::post('gestion/gestion_diotelectronica/presentar_diot_individual', 'GestionController@presentar_diot_individual');
Route::post('gestion/gestion_diotelectronica/presentar_diots', 'GestionController@presentarObligaciones');
Route::post('gestion/gestion_diotelectronica/despresentar_diots', 'GestionController@desPresentarObligaciones');
Route::post('gestion/gestion_diotelectronica/get_percent_diot', 'GestionController@getPercentDiots');


Route::get('balance/cxc', 'CxcController@grid');
Route::post('balance/get_cxc', 'CxcController@getCxc');
Route::get('balance/cxc/{idcliente}', 'CxcController@cxcCliente');
Route::post('balance/get_pagos_fact', 'CxcController@pagosFactura');
Route::post('balance/aplica_pago', 'CxcController@aplica_pago');
Route::post('balance/elimina_pago', 'CxcController@elimina_pago');

/*Route::group([
    'middleware' => [ 'auth', 'locale']
], function() {
		Route::get('/home', 'HomeController@index');
		Route::get('catalogos/clientes', 'CatalogoController@indexClientes');
});*/