<?php $__env->startSection('content'); ?>
<h1 class="h5 mb-1 text-gray-800">Catalogos > Clientes > Nuevo Cliente</h1>
<div class="row">
	<div class="col-12">
		<div class="card mb-4">
            <div class="card-header">
               Datos Cliente
            </div>
            <div class="card-body">
               <ul class="nav nav-tabs" id="myTab" role="tablist">
                 <li class="nav-item">
                   <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Datos Cliente</a>
                 </li>
                 <li class="nav-item" id="obligacionesTab" style="display:block;">
                   <a class="nav-link" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Obligaciones Fiscales</a>
                 </li>
               </ul>
               <div class="tab-content" id="myTabContent">
                 <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                        <div class="row">
                           <div class="col-12">
                              <label>Datos Generales</label>
                           </div>
                        </div>
                        <input type="hidden" id="idCliente" value="2">
                        <div class="row">
                           <div class="col-4">
                              <label>Rfc</label>
                              <input type="text" class="form-control input-sm" id="rfc">
                           </div>
                           <div class="col-4">
                              <label>Nombre</label>
                              <input type="text" class="form-control input-sm" id="nombre">
                           </div>
                           <div class="col-4">
                              <label>Email</label>
                              <input type="text" class="form-control input-sm" id="email">
                           </div>
                        </div>
                        <div class="row">
                           <div class="col-4">
                              <label>Telefono</label>
                              <input type="text" class="form-control input-sm" id="telefono">
                           </div>
                           <div class="col-8">
                              <label>Direccion</label>
                              <input type="text" class="form-control input-sm" id="direccion">
                           </div>
                        </div>
                        <div class="row">
                           <div class="col-4">
                              <label>Regimen Fiscal</label>
                              <select id="regimen" class="form-control" onchange="getObligaciones();">
                                 <option value="0">-Selecciona-</option>
                                 <?php $__currentLoopData = $info['tipo_persona']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($o->id); ?>"><?php echo e($o->persona); ?></option>
                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </select>
                           </div>
                        </div>
                        <div class="row">
                           <label>Claves de Acceso</label>
                        </div>
                        <div class="row">
                           <div class="col-3">
                              <label>CIEC</label>
                              <input type="text" class="form-control input-sm" id="ciec">
                           </div>
                           <div class="col-3">
                              <label>FIEL</label>
                              <input type="text" class="form-control input-sm" id="fiel">
                           </div>
                           <div class="col-3">
                              <label>CSD</label>
                              <input type="text" class="form-control input-sm" id="csd">
                           </div>
                            <div class="col-3">
                              <label>IMSS</label>
                              <input type="text" class="form-control input-sm" id="imss">
                           </div>   
                        </div>
                        <div class="row">
                           <div class="col-3">
                              <label>ISN</label>
                              <input type="text" class="form-control input-sm" id="isn">
                           </div>
                           <div class="col-3">
                              <label>IDSE</label>
                              <input type="text" class="form-control input-sm" id="idse">
                           </div>
                           <div class="col-3">
                              <label>FEIL Vences</label>
                              <input type="text" class="form-control input-sm datepicker" id="fiel_vence">
                           </div>
                           <div class="col-3">
                              <label>Sello Vence</label>
                              <input type="text" class="form-control input-sm datepicker" id="sello_vence">
                           </div>
           
                        </div>
                        <div class="row">
                           <div class="col-12" align="right">
                              <button class="btn btn-primary" onclick="guardarCliente();">Guardar</button>
                           </div>
                        </div>
                 </div>
                 <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                        <div class="row">
                           <label>Obligaciones Fiscales</label>
                        </div>

                        <div class="row">
                           <div class="col-4">
                              <label>Añadir</label>
                              <select id="obligaciones" class="form-control">
                                 <option value="0">-Selecciona-</option>
                                 <?php $__currentLoopData = $info['obligaciones']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($o->id); ?>" disp="<?php echo e($o->nombre_obligacion); ?>"><?php echo e($o->nombre_obligacion); ?></option>
                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </select>
                           </div>
                           <div class="col-4">
                              <label>Periocidad</label>
                              <select id="periocidadInput" class="form-control">
                                 <option value="0">-Selecciona-</option>
                                 <?php $__currentLoopData = $info['periocidad']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($o->id); ?>" disp="<?php echo e($o->nombre); ?>"><?php echo e($o->nombre); ?></option>
                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </select>
                           </div>
                           <div class="col-2">
                              <br>
                              <button class="btn btn-primary" onclick="agregaObligacion();">Agregar</button>
                           </div>
                        </div>
                        <br>
                        <div class="row">
                           <div class="col-12">
                              <table class="table table-bordered table-hover" id="tableObligaciones">
                                 <thead>
                                    <tr>
                                       <th>Obligacion</th>
                                       <th>Periocidad</th>
                                       <th><div align="center">Acciones</div></th>
                                    </tr>
                                 </thead>
                                 <tbody id="bodyObligaciones">

                                  
                                 </tbody>
                              </table>
                           </div>
                        </div>
                 </div>
               </div>





            </div>
        </div>
	</div>
</div>

<div class="modal fade" id="cargando">
   <div class="modal-dialog">
      <div class="modal-content">
         <div class="modal-header">
            <h4 class="modal-title">Cargando</h4>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-12 align-items-center">
                  <div align="center">
                     <img src="<?php echo e(asset('img/loading.gif')); ?>" width="400">
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<script>
  
   $(document).ready(function() {
      $('.datepicker').datepicker({
         format: 'yyyy-mm-dd',
      });

   });
   function getObligaciones(){
      $.ajax({
         url: 'get_obligaciones',
         type: 'POST',
         dataType: 'json',
         data: {regimen: $('#regimen').val()},
      })
      .done(function(resp) {
         console.log(resp);
         $('#obligaciones').empty()
         $.each(resp.obl, function(index, val) {
             $('#obligaciones').append('<option value="'+val.id+'">'+val.nombre_obligacion+'</option>')
         });
      })
      .fail(function() {
         console.log("error");
      })
      .always(function() {
         console.log("complete");
      });
      
   }
   function guardarCliente(){
      var idCliente = $('#idCliente').val()
      var rfc = $('#rfc').val()
      var nombre = $('#nombre').val()
      var email = $('#email').val()
      var telefono = $('#telefono').val()
      var direccion = $('#direccion').val()
      var regimen = $('#regimen').val()
      var ciec = $('#ciec').val()
      var fiel = $('#fiel').val()
      var csd = $('#csd').val()
      var imss = $('#imss').val()
      var isn = $('#isn').val()
      var idse = $('#idse').val()
      var fiel_vence = $('#fiel_vence').val()
      var sello_vence = $('#sello_vence').val()
      $('#cargando').modal()
      $.ajax({
         url: 'guarda_cliente',
         type: 'POST',
         dataType: 'json',
         data: {
            idCliente: idCliente,
            rfc : rfc,
            nombre : nombre,
            email : email,
            telefono : telefono,
            direccion : direccion,
            regimen : regimen,
            ciec : ciec,
            fiel : fiel,
            csd : csd,
            imss : imss,
            isn : isn,
            idse : idse,
            fiel_vence : fiel_vence,
            sello_vence : sello_vence,
         },
      })
      .done(function(resp) {
         console.log(resp);
         if(resp.id!='0'){
            alert(resp.mensaje)
            $('#idCliente').val(resp.id);
            $('#obligacionesTab').show();
            $('#cargando').modal('hide')
         }
      })
      .fail(function() {
         console.log("error");
      })
      .always(function() {
         console.log("complete");
      });
      
   }
   function agregaObligacion(){
      var periocidad = $('#periocidadInput').val();
      var periocidadDisplay = $('#periocidadInput > option:selected').attr('disp');
      var obligaciones = $('#obligaciones').val();
      var obligacionesDisplay = $('#obligaciones > option:selected').attr('disp');
      var idCliente = $('#idCliente').val();
      alert(obligacionesDisplay)
      if(idCliente==''){
         alert('Error');
         return false;
      }
      $.ajax({
         url: 'guarda_obligacion',
         type: 'POST',
         dataType: 'json',
         data: {
            periocidad: periocidad,
            obligaciones: obligaciones,
            idCliente: idCliente,
         },
      })
      .done(function(resp) {
         console.log(resp);
         if(resp.id!=0){
            html = '<tr id="obli_'+resp.id+'">';
            html +='<td>'+obligacionesDisplay+'</td>';
            html +='<td>'+periocidadDisplay+'</td>';
            html +='<td><div align="center"><button class="btn btn-danger" onclick="eliminaObligacion('+resp.id+')">X</button></div></td>';
            html +='</tr>';

            $('#bodyObligaciones').append(html)
         }
      })
      .fail(function() {
         console.log("error");
      })
      .always(function() {
         console.log("complete");
      });
      
   }
   function eliminaObligacion(id){
      var txt;
      var r = confirm("Deseas elminar la obligacion?");
      if (r == true) {
        $.ajax({
           url: 'elimina_obligacion',
           type: 'POST',
           dataType: 'json',
           data: {id: id},
        })
        .done(function(resp) {
           console.log(resp);
           if(resp.estatus==1){
               alert('Se elimino correctamente');
               $('#obli_'+id).remove();
           }
        })
        .fail(function() {
           console.log("error");
        })
        .always(function() {
           console.log("complete");
        });
        
      } else {
        return false;
      }
   }
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/tachisys/resources/views/catalogos/cliente/formcliente.blade.php ENDPATH**/ ?>