<?php $__env->startSection('content'); ?>
<h1 class="h5 mb-1 text-gray-800">Catalogos > Clientes</h1>
<div class="row">
	<div class="col-12">
		<div class="card mb-4">
            <div class="card-header">
                <a href="<?php echo e(url('catalogos/altaclientes')); ?>" class="btn btn-primary">Nuevo cliente</a>
            </div>
            <div class="card-body">
               <div class="row">
               	<div class="col-12">
               		<table class="table table-inverse" id="gridClientes">
               			<thead>
               				<tr>
               					<th>ID</th>
               					<th>RFC</th>
               					<th>Nombre</th>
               					<th>Regimen</th>
               					<th>Vencimiento Fiel</th>
               					<th>Vencimineto CSD</th>
               					<th>Estatus</th>
                        <th>Acciones</th>
               				</tr>
               			</thead>
               			<tbody>
               		
               			</tbody>
               		</table>
               	</div>
               </div>
            </div>
        </div>
	</div>
</div>
<script>
   $(document).ready(function() {
    $.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
}); 
      loadGrid();
   });
  function loadGrid(){
  
       //$('#').DataTable();
      $('#gridClientes').dataTable().fnDestroy();
      $('#gridClientes').DataTable( {
           processing: true,
           responsive: true,
           //serverSide: true,
           ajax: {
               url: "get_clientes",
               type: "POST",
           },
           columns: [
               { data: "id" },
               { data: "rfc" },
               { data: "nombre" },
               { data: "regimen_cliente" },
               { data: "fiel_vence" },
               { data: "sello_vence" },
               { data: "estatus" },
               { data: "acciones" },
           ],
           order: [[0,"desc"]]
       } );
      
   }
   function activardesactivar(id,estatus){
      var txt;
      var r = confirm("Deseas cambiar estatus del cliente?");
      if (r == true) {
        $.ajax({
          url: 'cambia_estatus_cliente',
          type: 'POST',
          dataType: 'json',
          data: {
            id: id,
            estatus: estatus
          },
        })
        .done(function(resp) {
          console.log("success");
          if(resp.estatus==1){
            alert('Se cambio con exito');
            loadGrid();
          }
        })
        .fail(function() {
          console.log("error");
        })
        .always(function() {
          console.log("complete");
        });
        
      } else {
        return false;
      }
   }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/tachisys/resources/views/catalogos/cliente/gridcliente.blade.php ENDPATH**/ ?>