<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class VentaServicio extends Model
{
    //
    public $timestamps = false;
    protected $table = 'ventas_servicios';
    protected $fillable = array(
        'id',
        'id_venta',
        'id_servicio',
        'precio_unitario',
        'subtotal',
        'precio_total',
        'cantidad',
        'comision_integrity',
        'comision_bancaria',
        'iva_integrity',
        'iva_comision_bancaria'
    );

    public function service()
    {
        return $this->belongsTo('App\Servicio', 'id_servicio');
    }
}
