@extends('includes.navbarclient')
@section('content')
<div class="container-fluid" id="xd">
	<div class="row" style="height: 100%;">
		<!--<div class="col-2" style="background-color: #93a6b7">
			<div class="row">
				<div class="col-12">
					<h1>{{ trans( 'messages.ventas' ) }}</h1>
				</div>
			</div>
			<hr>
			<div class="row">
				<div class="col-12 alert alert-dark">
                    <br>
					<h5><a href="{{ asset('/admin/customers') }}">+ {{ trans( 'messages.ventas' ) }}</a></h5>
				</div>
			</div>
		</div>-->
		<div class="col-12" id="divFormCliente" >
			<div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <h1>{{ trans( 'messages.ventas' ) }}</h1>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <br>
                        <!--<h5>+ {{ trans( 'messages.ventas' ) }}</h5>-->
                        <a href="{{ asset('/admin/customers') }}">+ {{ trans( 'messages.ventas' ) }}</a>
                    </div>
                </div>

                <div class="row">
                    <div class="col-9">
                        <form method="get" action="{{ url('admin/customers') }}">
                            <div class="row row-filters">
                                <div class="col-md-6">
                                    <div class="form-inline form-search">
                                        <div class="input-group">
                                            <input type="search" name="search" value="{{ request('search') }}" class="form-control form-control-sm" placeholder="{{ trans( 'messages.cliente' ) }}">
                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-secondary btn-sm">{{ trans( 'messages.filtrar' ) }}</button>
                                            </div>
                                        </div>
                                        &nbsp;
                                    </div>
                                </div>
        
                            </div>
                        </form>
                    </div>
                    <div class="col-3">
                        @can('create-extraordinaysale')
                            <a href="{{ url('/admin/transactions') }}" class="btn btn-secondary">{{ trans( 'messages.crear_venta_extraordinaria' ) }}</a>
                        @endcan
                    </div>
                </div>
                <br>

                

                <div class="row">
                    <div class="col-12">
                        <table id="customer" class="table table-bordered table-hover" style="background-color: white;">
                            <thead>
                                <tr>
                                    <th>{{ trans('messages.id_cliente') }}</th>
                                    <th>{{ trans('messages.no_cuenta_cuba') }}</th>
                                    <th>{{ trans('messages.cliente') }}</th>
                                    <th>{{ trans('messages.estatus') }}</th>
                                    <th>{{ trans('messages.acciones') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ( $clientes as $cliente )
                                
                                    <tr>
                                        <td>{{ $cliente->idCliente }}</td>
                                        <td>{{ $cliente->idCuba }}</td>
                                        <td>{{ $cliente->nombre }}</td>
                                        <td>
                                            @if ($cliente->estatus == "1")
                                                <span class="badge badge-pill badge-success">{{ trans('messages.activo') }}</span>
                                            @else
                                                <span class="badge badge-pill badge-danger">{{ trans('messages.inactivo') }}</span>
                                            @endif 
                                        </td>
                                        {{-- <td>{{ $cliente->estatus == "1" ? trans('messages.activo') : trans('messages.inactivo') }}</td> --}}
                                        <td><a href="{{ asset('/customers/'.$cliente->idCliente.'/transactions' ) }}">{{ trans('messages.resumen') }}</a></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                        
                </div>
			</div>
		</div>
	</div>
</div>
<script>
    $(document).ready(function() {
        $('#customer').DataTable();
    } );
</script>
@endsection
