<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Empresa;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class ConfiguracionController extends Controller
{
    public function index(){
    	$empresa = Empresa::find(1);
    	return view('config.empresa')->with('empresa',$empresa);
    }
    public function usuarios(){
    	return view('config.gridusuarios');
    }
    public function guarda_empresa(Request $r){

    	$empre = Empresa::find(1);

    	$cer = $r->file('cer');
    	$extension = $cer->getClientOriginalExtension();
        $nombreCer = $cer->getClientOriginalName();

    	$key = $r->file('cer');
    	$extensionKey = $key->getClientOriginalExtension();
        $nombreKey = $key->getClientOriginalName();

   		$data = [
   			'rfc' => strtoupper($r->rfc),
	        'razon_social' => $r->razon_social,
	        'regimen' => $r->regimen,
	        'direccion' => $r->direccion,
	        'cp' => $r->cp,
	        'municipio' => $r->municipio,
	        'estado' => $r->estado,
	        'pais' => $r->pais,
	        'user_pac' => $r->user_pac,
	        'contra_pac' => $r->contra_pac,
	        'cer' => $nombreCer,
	        'key' => $nombreKey,
	        'contra_csd' => $r->contra_csd,
	        'contra_ciec' => $r->contra_csd,
   		];

   		if($empre!=null){
    		//s$cliente = Empresa::update($data);
    		$empresa = Empresa::where('id', 1)
      				->update($data);
    	}else{
    		$empresa = Empresa::create($data);
    	}

        Storage::disk('local')->put( $nombreCer,  File::get($cer) );
        Storage::disk('local')->put( $nombreKey,  File::get($key) );
        $arrayName = array('estatus' => 1 );
        echo json_encode($arrayName);
    	exit();
    }
}
