@extends('layouts.app')
@section('content')
<div class="row">
  <div class="col-12">
    <nav aria-label="breadcrumb">
  <ol class="breadcrumb">
    <li class="breadcrumb-item" aria-current="page">Gestion Contable</li>
    <li class="breadcrumb-item active" aria-current="page">Almacen Digital</li>
  </ol>
</nav>
  </div>
</div> 
<div class="row">
	<div class="col-12">
		<div class="card mb-4">
            <div class="card-body">
              <div class="row">
                <div class="col-3">
                  <label>Cliente</label>
                  <select id="cliente" class="form-control">
                    <option value="0">Todos</option>
                    @foreach ($clientes as $cliente)
                      <option value="{{ $cliente->rfc }}">{{ $cliente->nombre }} ({{ $cliente->rfc }})</option>
                    @endforeach
                  </select>
                </div>
                <div class="col-3">
                  <label>Fechas</label>
                  <input type="text" class="form-control" name="daterange" id="rango" />
                </div>
               <!-- <div class="col-3">
                 <label>Consulta</label>
                 <select id="recibidoEmitido" class="form-control">
                   <option value="1">Emitidos</option>
                   <option value="2">Recibidos</option>
                 </select>
                </div>-->
                <div class="col-3">
                  <br>
                  <button class="btn btn-primary" onclick="getXMLs();">Descargar</button>
                  <button class="btn btn-primary" onclick="loadGrid();">Carga Grid</button>
                </div>
              </div>
              <br>
               <div class="row">
               	<div class="col-12">
               		<table class="table table-inverse" id="gridFacturas">
               			<thead>
               				<tr>
               					<th>Cliente</th>
               					<th>RFC</th>
                        <th>Folio</th>
                        <th>UUID</th>
               					<th>Monto</th>
               					<th>Tipo</th>
               					<th>Fecha</th>
               					<th>Estatus</th>
                        <th>Acciones</th>
               				</tr>
               			</thead>
               			<tbody>
               		
               			</tbody>
               		</table>
               	</div>
               </div>
            </div>
        </div>
	</div>
</div>

<div class="modal fade" id="cargando">
   <div class="modal-dialog">
      <div class="modal-content">
         <div class="modal-header">
            <h4 class="modal-title">Cargando</h4>
         </div>
         <div class="modal-body">
            <div class="row">
               <div class="col-12 align-items-center">
                  <div align="center">
                     <img src="{{ asset('img/loadin_gif.gif') }}" width="400">
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<script>
   $(document).ready(function() {
    $.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
}); 
    $('#rango').daterangepicker({
    opens: 'left'
  }, function(start, end, label) {
    console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
  });
     // loadGrid();
   });
   function getXMLs(){
    var cliente = $('#cliente').val();
    var fechas = $('#rango').val()
    $('#cargando').modal()
    $.ajax({
      url: 'getxmls',
      type: 'POST',
      dataType: 'json',
      async: false,
      data: {
        cliente: cliente,
        rango: fechas
      },
    })
    .done(function(resp) {
      console.log(resp);
      if(resp.estatus==1){
        $.ajax({
          url: 'verifica_solicitud_xml',
          type: 'POST',
          dataType: 'json',
          async: false,
          data: {idSol: resp.idPeticionXml},
        })
        .done(function(res) {
          console.log(res);
          //salert(res.estatus)
          if(res.estatus==1){
            //alert('eeee')
            $.ajax({
              url: 'verifica_solicitud_datos',
              type: 'POST',
              dataType: 'json',
              async: false,
              data: {idSol: resp.idPeticionDatos},
            })
            .done(function(re) {
              console.log(re);
              if(re.estatus==1){
                loadGrid();
                $('#cargando').modal('hide')
              }else{
                $('#cargando').modal('hide')
                alert(re.msj)
              }
            })
            .fail(function() {
              console.log("error");
            })
            .always(function() {
              console.log("complete");
            });
            
          }else{
            alert(res.msj)
            $('#cargando').modal('hide')
            return false;
          }

        })
        .fail(function() {
          console.log("error");
        })
        .always(function() {
          console.log("complete");
        });
        
      }else{
        alert('erroooooe')
        $('#cargando').modal('hide')
      }
    })
    .fail(function() {
      console.log("error");
    })
    .always(function() {
      console.log("complete");
    });
    
   }
  function loadGrid(){
      var cliente = $('#cliente').val();
      var fechas = $('#rango').val()
       //$('#').DataTable();
      $('#gridFacturas').dataTable().fnDestroy();
      $('#gridFacturas').DataTable( {
           processing: true,
           responsive: true,
           //serverSide: true,
           ajax: {
               url: "get_facturas_grid",
               type: "POST",
               data: {
                cliente: cliente,
                rango: fechas
              },
           },
           columns: [
               { data: "razon_social_receptor" },
               { data: "rfc_receptor" },
               { data: "folio" },
               { data: "uuid" },
               { data: "monto" },
               { data: "tipo" },
               { data: "fecha_emision" },
               { data: "estatus" },
               { data: "acciones" },
           ],
           order: [[0,"desc"]]
       } );
      
   }
   /*function activardesactivar(id,estatus){
      var txt;
      var r = confirm("Deseas cambiar estatus del cliente?");
      if (r == true) {
        $.ajax({
          url: 'cambia_estatus_cliente',
          type: 'POST',
          dataType: 'json',
          data: {
            id: id,
            estatus: estatus
          },
        })
        .done(function(resp) {
          console.log("success");
          if(resp.estatus==1){
            alert('Se cambio con exito');
            loadGrid();
          }
        })
        .fail(function() {
          console.log("error");
        })
        .always(function() {
          console.log("complete");
        });
        
      } else {
        return false;
      }
   } */
</script>
@endsection