<?php $__env->startSection('content'); ?>
<h1 class="h5 mb-1 text-gray-800">Blance Flujo Efectivo > Fliujo de Gastos</h1>
<div class="row">
	<div class="col-12">
		<div class="card mb-4">
            <div class="card-header">
                <!--<a href="<?php echo e(url('catalogos/altaclientes')); ?>" class="btn btn-primary">Nuevo Gasto</a>-->
                <a class="btn btn-primary" data-toggle="modal" href='#modal-id'>Nuevo Gasto</a>
            </div>
            <div class="card-body">
               <div class="row">
                  <!--<div class="col-2">
                     <label>Año</label>
                     <input type="text" class="form-control" id="">
                  </div>-->
                  <div class="col-2">
                     <label>Tipo</label>
                    <select id="filTipo" class="form-control" onchange="loadGrid();">
                       <option value="0">-Todos-</option>
                       <option value="1">Fijo</option>
                       <option value="2">Variable</option>
                     </select>
                  </div>
                  <div class="col-2">
                     <label>Periocidad</label>
                     <select id="filPeriocidad" class="form-control" onchange="loadGrid();">
                       <option value="0">-Todos-</option>
                       <option value="1">Mensual</option>
                       <option value="2">Anual</option>
                     </select>
                  </div>
                  <div class="col-2">
                     <label>Desde</label>
                      <input type="text" class="form-control" id="filDesde">
                  </div>
                  <div class="col-2">
                     <label>Periocidad</label>
                     <input type="text" class="form-control" id="filHasta">
                  </div>
               </div>
               <div class="row">
               	<div class="col-12">
               		<table class="table" id="gridGastos">
               			<thead>
               				<tr>
                        <th>ID</th>
               					<th>Tipo</th>
               					<th>Fecha</th>
               					<th>Concepto</th>
               					<th>Importe</th>
               					<th>Periocidad</th>
                        <th>Estatus</th>
               					<th>Acciones</th>
               					
               				</tr>
               			</thead>
               			<tbody>
               			</tbody>
               		</table>
               	</div>
               </div>
            </div>
        </div>
	</div>
</div>

<div class="modal fade" id="modal-id">
   <div class="modal-dialog">
      <div class="modal-content">
         <div class="modal-header bg-dark">
            <h4 class="modal-title">Nuevo Gasto</h4>
            <input type="hidden" id="idGastoH">
              <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
         </div>
         <div class="modal-body">
         <div class="row">
            <div class="col-12">
               <div class="input-group">
                 <div class="input-group-prepend">
                   <span class="input-group-text" id="">Tipo Gasto</span>
                 </div>
                 <select id="tipoGasto" class="form-control">
                   <option value="1">Fijo</option>
                   <option value="2">Variable</option>
                 </select>
               </div>
            </div>
         </div>
         <br>
         <div class="row">
            <div class="col-12">
                             <div class="input-group">
                 <div class="input-group-prepend">
                   <span class="input-group-text" id="">Concepto</span>
                 </div>
                 <input type="text" id="concepto" class="form-control">
               </div>
            </div>
          </div>
          <br>
            <div class="row">
              <div class="col-12">
                <div class="input-group">
                 <div class="input-group-prepend">
                   <span class="input-group-text" id="">Importe $</span>
                 </div>
                 <input type="number" id="importe" class="form-control">
               </div>
              </div>
            </div>
            <br>  
            <div class="row">
              <div class="col-12">
                               <div class="input-group">
                 <div class="input-group-prepend">
                   <span class="input-group-text">Periocidad</span>
                 </div>
                 <select id="periocidad" class="form-control">
                   <option value="1">Mensual</option>
                   <option value="2">Anual</option>
                 </select>
               </div>
              </div>
            </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
            <button type="button" class="btn btn-primary" onclick="saveGasto();">Guardar</button>
         </div>
      </div>
   </div>
</div>
<script>
     $(document).ready(function() {
    $.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
}); 
      loadGrid();
   });
    function loadGrid(){
  
       //$('#').DataTable();
      $('#gridGastos').dataTable().fnDestroy();
      $('#gridGastos').DataTable( {
           processing: true,
           responsive: true,
           serverSide: true,
           ajax: {
               url: "get_gastos",
               type: "POST",
               //type : 'post'
               data : { 
                  tipo : $('#filTipo').val(),
                  periocidad : $('#filPeriocidad').val(),
                  desde : $('#filDesde').val(),
                  hasta : $('#filHasta').val(),
                },
           },
           columns: [
               { data: "id" },
               { data: "tipo" },
               { data: "fecha" },
               { data: "concepto" },
               { data: "importe" },
               { data: "periocidad" },
               { data: "estatus" },
               { data: "acciones" },
           ],
           order: [0,"desc"]
      } );
      
   }
     function saveGasto(){
      var tipo = $('#tipoGasto').val()
      var concepto = $('#concepto').val();
      var importe = $('#importe').val()
      var periodo = $('#periocidad').val()
      var idGasto = $('#idGastoH').val()
      if(concepto==''){
        alert('Debes de agregar un concepto');
        return false;
      }
      if(importe=='' || importe < 0){
        alert('El importe no es valido')
        return false;
      }
  
      $.ajax({
        url: 'save_gasto',
        type: 'POST',
        dataType: 'json',
        data: {
          tipo : tipo,
          concepto : concepto,
          importe : importe,
          periocidad : periodo,
          idGasto : idGasto,
        },
      })
      .done(function(resp) {
        console.log(resp);
        if(resp.estatus==1){
          alert('Se guardo con exito');
          $('#modal-id').modal('hide')
          //loadGrid();
        }else{
          alert('Ocurrio un erro al guardar el gasto.')
          $('#modal-id').modal('hide')
        }
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
      
     }
    function editarGasto(id){
      $.ajax({
        url: 'get_info_gasto',
        type: 'POST',
        dataType: 'json',
        data: {id: id},
      })
      .done(function(resp) {
        console.log(resp);
        var tipo = $('#tipoGasto').val(resp.tipo)
        var concepto = $('#concepto').val(resp.concepto);
        var importe = $('#importe').val(resp.importe)
        var periodo = $('#periocidad').val(resp.periocidad)
        var idGasto = $('#idGastoH').val(id)
        $('#modal-id').modal('show')
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });
      
    }
    function activardesactivar(id,estatus){
      var txt;
      var r = confirm("Deseas cambiar estatus del gasto?");
      if (r == true) {
        $.ajax({
          url: 'cambia_estatus_gasto',
          type: 'POST',
          dataType: 'json',
          data: {
            id: id,
            estatus: estatus
          },
        })
        .done(function(resp) {
          console.log("success");
          if(resp.estatus==1){
            alert('Se cambio con exito');
            loadGrid();
          }
        })
        .fail(function() {
          console.log("error");
        })
        .always(function() {
          console.log("complete");
        });
        
      } else {
        return false;
      }
   }
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/tachisys/resources/views/balance/flujogastos.blade.php ENDPATH**/ ?>