<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;

use App\User;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class ChangePasswordController extends Controller
{
    public function __construnct(){
    	$this->middleware('auth');
    }
    public function index(){
    	return view('auth.passwords.change');

    }
    public function changePassword(Request $r){
    	$this->validate($r,[
    		'oldpassword' => 'required',
    		'password' => 'required|confirmed'
    	]);

    	$hashedPassword = Auth::user()->password;

    	if(Hash::check($r->oldpassword,$hashedPassword)){
    		$user = User::find(Auth::user()->id);	
    		$user->password = Hash::make($r->password);
    		$user->save();
    		Auth::logout();
    		return redirect()->route('login')->with('successMsg','Passwors is Changed Succesfuly');
    	}else{
    		return redirect()->back()->with('errorMsg','Current Password is invalid');
    	}
    }

}

