<?php

namespace App\Http\Controllers;

use Auth;
use App\Http\Requests;
use DB;
use Input;
use Session;
use DateTime;
use DateTimeZone;
use PDF;
use Mail;
use App\Models\sc_usuarios;
use App\Models\Servicio;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Illuminate\Http\Request;
use MercadoPago\Item;
use MercadoPago\MerchantOrder;
use MercadoPago\Payer;
use MercadoPago\Payment;
use MercadoPago\Preference;
use MercadoPago\SDK;

use App\Models\Organizacion; 
use Bbva;
use App\Venta;
use App\TipoDeCambio;
use App\User;
use App\VentaServicio;
use App\Cliente;



class CarritoController extends Controller
{
    public function addItemCart(Request $req){


        $servicio = Servicio::find($req->idSer);
        $cart = session()->get('cart');
        
        ///Si el carro esta vacio y es el primer servicio en agregar
        if(!$cart){
            $cart = [
                $req->idSer => [
                    'idServicio' => $req->idSer,
                    'nombre' => $servicio->nombre,
                    'number_service' => $servicio->numero_servicio,
                    'img' => $servicio->imagen,
                    'costo' => $req->costo,
                    'comisionIAS' => $req->comiIAS,
                    'comisionBanc' => $req->comiBan,
                    'ivaIAS' => $req->IVAIas,
                    'ivaBan' => $req->IVABanc,
                    'impuestos' => $req->IVABanc + $req->IVAIas,
                    'moneda' => $req->moneda,
                    'tipoCambio' => $req->tipoCambio,
                    'idTC' => $req->idTC,
                    'cantidad' => $req->cant,
                    'subtotal' => $req->subtotal,
                    'total' => $req->total,
                    'porComIas' => $req->porComIas,
                    'porComBanc' => $req->porComBanc,
                ]
            ];
            session()->put('cart',$cart);
            $totalItems = 0;
            //print_r(session('cart'));
            foreach (session('cart') as $key => $value) {
                $totalItems += floatval($value['cantidad']);
	    }
	    $itemsSesion = session()->get('itemsSesion');
            if(!$itemsSesion){
                session()->put('itemsSesion',$totalItems);
            }
            $res = array('result' => 1, 'msj' => 'Se agrego a lista de servicios','totalItems' => $totalItems );
            //echo json_encode($res);
            return response()->json($res);
            
            
        }
        ////Si el carrito no esta vacion, revisa si el servicio ya esta en el carrito y lo actualiza
        if(isset($cart[$req->idSer])){
              $cart[$req->idSer] = [
                    'idServicio' => $req->idSer,
                    'nombre' => $servicio->nombre,
                    'number_service' => $servicio->numero_servicio,
                    'img' => $servicio->imagen,
                    'costo' => $req->costo,
                    'comisionIAS' => $req->comiIAS,
                    'comisionBanc' => $req->comiBan,
                    'ivaIAS' => $req->IVAIas,
                    'ivaBan' => $req->IVABanc,
                    'impuestos' => $req->IVABanc + $req->IVAIas,
                    'moneda' => $req->moneda,
                    'tipoCambio' => $req->tipoCambio,
                    'idTC' => $req->idTC,
                    'cantidad' => $req->cant,
                    'subtotal' => $req->subtotal,
                    'total' => $req->total,
                    'porComIas' => $req->porComIas,
                    'porComBanc' => $req->porComBanc,
            ];
            session()->put('cart',$cart);
            $totalItems = 0;
            foreach (session('cart') as $key => $value) {
                $totalItems += floatval($value['cantidad']);
	    } 
  	    $itemsSesion = session()->get('itemsSesion');
            if(!$itemsSesion){
                session()->put('itemsSesion',$totalItems);
            }
            $res = array('result' => 1, 'msj' => 'Se agrego a lista de servicios','totalItems' => $totalItems );
            //echo json_encode($res);
            return response()->json($res);
            //exit();
            
        }else{
            $cart[$req->idSer] = [
                    'idServicio' => $req->idSer,
                    'nombre' => $servicio->nombre,
                    'number_service' => $servicio->numero_servicio,
                    'img' => $servicio->imagen,
                    'costo' => $req->costo,
                    'comisionIAS' => $req->comiIAS,
                    'comisionBanc' => $req->comiBan,
                    'ivaIAS' => $req->IVAIas,
                    'ivaBan' => $req->IVABanc,
                    'impuestos' => $req->IVABanc + $req->IVAIas,
                    'moneda' => $req->moneda,
                    'tipoCambio' => $req->tipoCambio,
                    'idTC' => $req->idTC,
                    'cantidad' => $req->cant,
                    'subtotal' => $req->subtotal,
                    'total' => $req->total,
                    'porComIas' => $req->porComIas,
                    'porComBanc' => $req->porComBanc,
            ];
            session()->put('cart',$cart);
            
            $totalItems = 0;
            foreach (session('cart') as $key => $value) {
                $totalItems += floatval($value['cantidad']);
	    }
	    $itemsSesion = session()->get('itemsSesion');
            if(!$itemsSesion){
                session()->put('itemsSesion',$totalItems);
            }
            $res = array('result' => 1, 'msj' => 'Se agrego a lista de servicios','totalItems' => $totalItems );
            //echo json_encode($res);
            return response()->json($res);
            //exit();
            
        }
        

    }
    public function updateItemCart2(Request $req){

        $servicio = Servicio::find($req->idSer);
        $cart = session()->get('cart');
        
        ///Si el carro esta vacio y es el primer servicio en agregar
        if(!$cart){
            $cart = [
                $req->idSer => [
                    'idServicio' => $req->idSer,
                    'name' => $servicio->nombre,
                    'number_service' => $servicio->numero_servicio,
                    'img' => $servicio->imagen,
                    'precio_bruto' => $servicio->precio_bruto,
                    'comisionIAS' => $servicio->comisionIAS,
                    'comisionPago' => $servicio->comisionPago,
                    'tipoCambio' => $servicio->tipoCambio,
                    'precio_total' => $servicio->precio_total,
                    'cantidad' => $req->cant,
                    'total' => ($req->cant *$servicio->precio_total)
                ]
            ];
            session()->put('cart',$cart);
            $totalItems = 0;
            //print_r(session('cart'));
            foreach (session('cart') as $key => $value) {
                $totalItems += floatval($value['cantidad']);
            }
            $res = array('result' => 1, 'msj' => 'Se agrego a lista de servicios','totalItems' => $totalItems );
            //echo json_encode($res);
            return response()->json($res);
            
            
        }
        ////Si el carrito no esta vacion, revisa si el servicio ya esta en el carrito y lo actualiza
        if(isset($cart[$req->idSer])){
            $cart[$req->idSer]['cantidad'] = $req->cant;
            $cart[$req->idSer]['total'] = $cart[$req->idSer]['cantidad'] * $cart[$req->idSer]['precio_total'];
            session()->put('cart',$cart);
            $totalItems = 0;
            foreach (session('cart') as $key => $value) {
                $totalItems += floatval($value['cantidad']);
            }
            $res = array('result' => 1, 'msj' => 'Se agrego a lista de servicios','totalItems' => $totalItems );
            //echo json_encode($res);
            return response()->json($res);
            //exit();
            
        }else{
            $cart[$req->idSer] = [
                    'idServicio' => $req->idSer,
                    'name' => $servicio->nombre,
                    'number_service' => $servicio->numero_servicio,
                    'img' => $servicio->imagen,
                    'precio_bruto' => $servicio->precio_bruto,
                    'comisionIAS' => $servicio->comisionIAS,
                    'comisionPago' => $servicio->comisionPago,
                    'tipoCambio' => $servicio->tipoCambio,
                    'precio_total' => $servicio->precio_total,
                    'cantidad' => $req->cant,
                    'total' => ($req->cant *$servicio->precio_total)
            ];
            session()->put('cart',$cart);
            
            $totalItems = 0;
            foreach (session('cart') as $key => $value) {
                $totalItems += floatval($value['cantidad']);
            }
            $res = array('result' => 1, 'msj' => 'Se agrego a lista de servicios','totalItems' => $totalItems );
            //echo json_encode($res);
            return response()->json($res);
            //exit();
            
        }
    }
    public function carrito(){
        //$this->vaciaCarito();
        $totalCarrito = 0;
        $cart = session()->get('cart');
        //dd(session('cart'));
        //print_r(session('cart'));
        //exit();
        ///Si el carro esta vacio y es el primer servicio en agregar
     
        $totales['subtotal'] = 0 ;
        $totales['impuestos']  = 0;
        if($cart){
            foreach (session('cart') as $key => $value) {
                $totalCarrito += floatval($value['total']);
                $moneda['moneda'] = $value['moneda'];
                $moneda['tipoCambio'] = $value['tipoCambio'];
                $totales['subtotal'] += $value['subtotal'];
                $totales['impuestos'] += $value['impuestos'];

            }
        }else{
            //$totalCarrito += floatval($value['total']);
                $moneda['moneda'] ='';
                $moneda['tipoCambio'] = '';
                //$totales['subtotal'] += $value['subtotal'];
                //$totales['impuestos'] += $value['impuestos'];
        }
        return view('carrito.carrito')->with('totalCarrito',$totalCarrito)->with('moneda',$moneda)->with('totales',$totales);
    }
    public function vaciaCarito(){
        session()->forget('cart');
	session()->forget('itemsSesion');   
	$res = array('result' => 1, 'msj' => 'Se vacio la lista de servicios','totalItems' => 0 );
        return response()->json($res);

    }
    public function eliminaItemCarrito(Request $req){

        //$products = session()->pull('cart'); // Second argument is a default value
        $products = session()->get('cart');
        //dd($products);
        $cantidad =  $products[$req->id]['cantidad'];
         $itemsSesion = session()->get('itemsSesion');
            if($itemsSesion){
                $to = $itemsSesion - $cantidad;
                if($to < 1){
                    session()->forget('itemsSesion');
                }else{
                    session()->put('itemsSesion',$to);
                }
                
            }
        unset($products[$req->id]);
        session()->put('cart', $products);
        $res = array('result' => 1, 'msj' => 'Se agrego al carrito' );
        return response()->json($res);
    }
    public function pagar_(){
        

        $totalCarrito = 0;
        $servicios = '';
        $cart = session()->get('cart');
            //print_r(session()->get('cart'));
            //exit();
        ///Si el carro esta vacio y es el primer servicio en agregar
        if($cart){
            
            foreach (session()->get('cart') as $key => $value) {
                $totalCarrito += floatval($value['total']);
                $servicios .= $value['nombre'].' + ';
            }
        }

        //echo $totalCarrito;
        //echo 'ddddd '.$servicios;
        $totalCarrito = round($totalCarrito);
        ////Iteraccion Mercado Pago
        SDK::setAccessToken(env('PROD_ACCESS_TOKEN'));
        /*$payer = new Payer();
        $payer->name = "Charles";
        $payer->surname = "Luevano";
        $payer->email = "charles@hotmail.com";
        $payer->date_created = "2018-06-02T12:58:41.425-04:00";
        $payer->phone = array(
        "area_code" => "",
        "number" => "949 128 866"
        );

        $payer->identification = array(
        "type" => "DNI",
        "number" => "12345678"
        );

        $payer->address = array(
        "street_name" => "Cuesta Miguel Armendáriz",
        "street_number" => 1004,
        "zip_code" => "11020"
        );*/
        // Crea un objeto de preferencia
        $preference = new Preference();

        // Crea un ítem en la preferencia
        $item = new Item();
        $item->title = $servicios;
        $item->quantity = 1;
        $item->unit_price = $totalCarrito;
        $preference->items = array($item);
        $preference->save();

       
        //return view('servicios.pagoprueba')->with('total',$totalCarrito);
        return view('servicios.pagoprueba')->with('preference',$preference)->with('total',$totalCarrito);

    }
    public function procesar_pago2(){
        $apro = 0;
        $totalCarrito = 12300;
        return view('carrito.pago_result')->with('estatus',$apro)->with('total',$totalCarrito);
    }
    public function procesar_pago($id,Request $req){

	$bbva = Bbva::getInstance('mtupve4cduwfgbewhado', 'sk_0acd90e6144d479d9ac712a5445d8153');
        //$bbva = Bbva::getInstance('mitwmpcuczp60s43iuhx', 'sk_86f04daee48843ecbaf88926755650ed');
        //Bbva::getSandboxMode(false);
	Bbva::setProductionMode(true);
	//$bbva = Bbva::getInstance('mptdggroasfcmqs8plpy', 'sk_326c6d0443f6457aae29ffbd48f7d1be');
	$charge = $bbva->charges->get($req->id);
	
	$organizacion =  Organizacion::find(1);
        $totalCarrito = 0;
        $ivaIAS = 0;
        $ivaBan = 0;
        $comisionIAS = 0;
        $comisionBanc = 0;
    /*    foreach (session()->get('cart') as $key => $value) {
            $totalCarrito += floatval($value['total']);
            $ivaIAS += floatval($value['ivaIAS']);
            $ivaBan += floatval($value['ivaBan']);
            $moneda = $value['moneda'];
            $idTC = $value['idTC'];
            $comisionIAS += floatval($value['comisionIAS']);
            $comisionBanc += floatval($value['comisionBanc']);
            $porComIas = $value['porComIas']; 
	  }*/
	$ventaGenerales =  Venta::find($id);
        $totalCarrito = $ventaGenerales->total;
        $moneda = $ventaGenerales->moneda;

        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d H:i:s");
        if($charge->status=='completed'){

            /*$idIns = DB::table('ventas')->insertGetId([
                'idCliente' =>  Auth::user()->cliente->idCliente,
                'total' => $totalCarrito,
                'payment_id' => $req->payment_id,
                'moneda' => 1,
                'fecha' => $fechaactual,
                'tipo' => 1,
                'estatus' => 2,
            ]);*/
	 	$idIns = DB::table('ventas')
                ->where('id',$id)
                ->update([
                    'payment_id' => $req->id,
                    'estatus' => 2,
                ]);
               /* $nuevaVenta = Venta::create([
                    'idCliente' => Auth::user()->cliente->idCliente,
                    'total' => $totalCarrito,
                    'iva_comision' => $ivaIAS,
                    'iva_bancaria' => $ivaBan,
                    'payment_id' => $req->id,
                    'moneda' => $moneda,
                    'tipo_cambio_id' => $idTC,
                    'porcentaje_tipo_cambio' => (  ($moneda == 'USD') ? $organizacion->porcentaje_dolar : $organizacion->porcentaje_euro  ),
                    'fecha' => $fechaactual,
                    'tipo' => 1,
                    'comision_bancaria' => $comisionBanc,
                    'comision_integrity' => $comisionIAS,
                    'porcentaje_comision_bancaria' => $organizacion->comision_bancario,
                    'porcentaje_comision_integrity' => $porComIas,
                    'comentarios' => session('comentarios'),
                    'estatus' => 2,
                ]);

            foreach (session()->get('cart') as $key => $value) {
                $idIns2 = DB::table('ventas_servicios')->insertGetId([
                    'id_venta' => $nuevaVenta->id,
                    'id_servicio' => $value['idServicio'],
                    'precio_unitario' => $value['costo'],
                    'subtotal' => $value['subtotal'],
                    'precio_total' => $value['total'],
                    'cantidad' => $value['cantidad'],
                    'comision_integrity' => $value['comisionIAS'],
                    'comision_bancaria' => $value['comisionBanc'],
                    'iva_integrity' => $value['ivaIAS'],
                    'iva_comision_bancaria' =>$value['ivaBan']

                ]);
                  
	    }*/
		session()->forget('cart');
		session()->forget('itemsSesion');
	                 //$id=98;

         $idVenta = $id;
          $idPayment = $req->id;  
          /*$total = '489595';
          $moneda = 'USD'; */
            $this->envia_comprobante($id,$idPayment,$totalCarrito,$moneda);
            return view('carrito.pago_result')->with('id_venta',$id)->with('estatus',1)->with('total',$totalCarrito);

           
        }else{
            return view('carrito.pago_result')->with('id_venta',0)->with('estatus',0)->with('total',$totalCarrito);
        }

    }
    public function getInfoVenta(Request $r){
        $query = 'select vs.*,s.nombre,s.numero_servicio, v.comision_bancaria as cb
                from ventas_servicios vs
                left join ias_servicio s on vs.id_servicio=s.idServicio
                left join ventas v on vs.id_venta=v.id
                where vs.id_venta='.$r->idVenta;
        $servicios = DB::select($query);
        $servicios = $this->object_to_array($servicios);

        $res = array('result' => $servicios );
        return response()->json($res);

    }
    public function object_to_array($data) {
        if (is_array($data) || is_object($data)) {
            $result = array();
            foreach ($data as $key => $value) {
                $result[$key] = $this->object_to_array($value);
            }
            return $result;
        }
    return $data;
    }
    public function pagarPendiente($id){
        echo $id.'<>';
        exit();
        $query = 'select vs.*,s.nombre,s.numero_servicio
                from ventas_servicios vs
                left join ias_servicio s on vs.id_servicio=s.idServicio
                where vs.id_venta=';
                echo $query;
                exit();
        $servi = DB::select($query);
        $servi = $this->object_to_array($servi);
        $totalCarrito = 0;
        $servicios = '';
      
            //print_r(session()->get('cart'));
            //exit();
        ///Si el carro esta vacio y es el primer servicio en agregar
 
            
            foreach ($servi as $key => $value) {
                $totalCarrito += floatval($value['precio_total']);
            $servicios .= $value['nombre'].' + ';
            }
        

        //echo $totalCarrito;
        //echo 'ddddd '.$servicios;
        $totalCarrito = round($totalCarrito);
        ////Iteraccion Mercado Pago
        SDK::setAccessToken(env('PROD_ACCESS_TOKEN'));
        /*$payer = new Payer();
        $payer->name = "Charles";
        $payer->surname = "Luevano";
        $payer->email = "charles@hotmail.com";
        $payer->date_created = "2018-06-02T12:58:41.425-04:00";
        $payer->phone = array(
        "area_code" => "",
        "number" => "949 128 866"
        );

        $payer->identification = array(
        "type" => "DNI",
        "number" => "12345678"
        );

        $payer->address = array(
        "street_name" => "Cuesta Miguel Armendáriz",
        "street_number" => 1004,
        "zip_code" => "11020"
        );*/
        // Crea un objeto de preferencia
        $preference = new Preference();

        // Crea un ítem en la preferencia
        $item = new Item();
        $item->title = $servicios;
        $item->quantity = 1;
        $item->unit_price = $totalCarrito;
        $preference->items = array($item);
        $preference->save();

       
        //return view('servicios.pagoprueba')->with('total',$totalCarrito);
        return view('servicios.pagoprueba')->with('preference',$preference)->with('total',$totalCarrito);
    }
    public function trae_tipocambio(Request $r){


        $query = 'SELECT comision_bancaria_eur,comision_bancaria_usd,porcentaje_dolar,porcentaje_euro from organizacion where id=1';
        $comisionBancaria = DB::select($query);
        $comisionBancaria = $this->object_to_array($comisionBancaria);

        $res = DB::table('tipo_de_cambios')->where('moneda',$r->moneda)->orderBy('id','desc')->first();
        $aumento = (3 * $res->monto) / 100;
	$tcpAum = ($res->monto + $aumento);

        $res2 = DB::table('organizacion')->first();
        if($r->moneda=='USD'){
            $porcentaje = $res2->porcentaje_dolar;
        }else{
            $porcentaje = $res2->porcentaje_euro;
        }
        if($r->moneda=='USD'){
            $comB = $comisionBancaria[0]['comision_bancaria_usd'];
        }else{
            $comB = $comisionBancaria[0]['comision_bancaria_eur'];
        }
       // echo $res->monto;
        $res3 = array('tp' => $tcpAum,'moneda' => $r->moneda, 'porce'=> $porcentaje, 'id' => $res->id,'comisionBan' =>$comB);
        return response()->json($res3);
    }
    public function add_comentarios(Request $r){
        
        session(['comentarios' => $r->comentarios]);
        $res = array('result' => 1, 'msj' => 'Se agrego al carrito' );
        return response()->json($res);
    }
    public function trae_rangos(Request $re){
        $query = 'SELECT porcentaje from rangos_comisiones where desde <= '.$re->costo.' and hasta >='.$re->costo.'';
        $rangos = DB::select($query);
        $rangos = $this->object_to_array($rangos);
        $res = array('porcentaje' => $rangos[0]['porcentaje']);
        return response()->json($res);
    }
    public function pagar($idVenta){
        $totalCarrito = 0;
        $servicios = '';
        $cart = session()->get('cart');
            //print_r(session()->get('cart'));
            //exit();
        ///Si el carro esta vacio y es el primer servicio en agregar
        if($cart){
            
            foreach (session()->get('cart') as $key => $value) {
                $totalCarrito += floatval($value['total']);
                $servicios .= $value['nombre'].' + ';
                $tiCamb = $value['tipoCambio'];
            }
        }
        
            $totalCarrito = $totalCarrito * $tiCamb;
            $totalCarrito = $totalCarrito;
            $totalCarrito = str_replace(',', '', number_format($totalCarrito,2));
        //echo $totalCarrito;
        //exit();
        //exit();
        //echo Auth::user()->cliente->idCliente;
        $cliente =  Cliente::find(Auth::user()->cliente->idCliente);
        //dd($cliente);
        //echo $cliente->nombre;
        //exit();
       /* $item = new Item();
        $item->title = $servicios;
        $item->quantity = 1;
        $item->unit_price = $totalCarrito;
        $preference->items = array($item);
        $preference->save();*/
        $order = rand(1,100000000);
        //$bbva = Bbva::getInstance('moiep6umtcnanql3jrxp', 'sk_3433941e467c4875b178ce26348b0fac');
	//$bbva = Bbva::getInstance('mptdggroasfcmqs8plpy', 'sk_326c6d0443f6457aae29ffbd48f7d1be');
//		Bbva::setProductionMode(true);
	//Bbva::setId('mitwmpcuczp60s43iuhx');
	// Bbva::setApiKey('sk_86f04daee48843ecbaf88926755650ed');
        $bbva = Bbva::getInstance('mtupve4cduwfgbewhado', 'sk_0acd90e6144d479d9ac712a5445d8153');
	//$bbva = Bbva::getInstance('mitwmpcuczp60s43iuhx', 'sk_86f04daee48843ecbaf88926755650ed');
	//Bbva::getSandboxMode(false);
	Bbva::setProductionMode(true);
	//Bbva::getProductionMode();

	//var_dump($e);
	//exit();	
	 //Bbva::setProductionMode(true);
/*	$refundData = array(
    'description' => 'Reembolso',
    'amount' => 105.32
	);

$charge = $bbva->charges->get('trnvyenvfovhisex2ql9');
$charge->refund($refundData);
 */
       //	$totalCarrito = 284.29;
	//$totalCarrito = 1.00;
	$chargeRequest = array(
            'affiliation_bbva' => '4273468',
            'amount' => $totalCarrito,
            'description' => 'Servicio de Navegacion',
	    'currency' => 'MXN',
	   /* 'payment_plan' => array(
		    "payments" => "6",
  		    "payments_type" => "WITHOUT_INTEREST",
   		    "deferred_months" => '3'
	    ),*/
         // 'use_3d_secure' => true,
	    'order_id' => 'oid-'.$idVenta.'-'.$order,
            'redirect_url' => 'https://sistema.aviation-system.com/procesar_pago/'.$idVenta,
            'customer' => array(
                'name' => $cliente->nombre,
                'last_name' => '',
                'email' => $cliente->email,
                'phone_number' => $cliente->telefono)
        );

	$charge = $bbva->charges->create($chargeRequest);
        //var_dump($charge);
        //exit();
        //echo $charge->payment_method->url;
	session()->forget('cart');
        session()->forget('itemsSesion');
	return view('servicios.pagoprueba')->with('preference',$charge->payment_method->url)->with('total',$totalCarrito);
        //print_r($charge);
    }
    public function pagarPendientesBBVA(Request $re){
        //echo $re->string;

        $string = trim($re->string,'-');
        $stringEnvio = trim($re->string,'-');

        $string = str_replace('-', ',', $string);
        $organizacion =  Organizacion::find(1);
        $porcentajeTipoCambioUS = $organizacion->porcentaje_dolar;
        $porcentajeTipoCambioEU = $organizacion->porcentaje_euro;

        $query = 'SELECT total as total,tipo_cambio_id,moneda from ventas where id in ('.$string.')';
        $ventas = DB::select($query);
        $ventas = $this->object_to_array($ventas);
        $total = 0;
        $totalSinConversion = 0;
        foreach ($ventas as $key => $value) {
            //echo 'e-'.$value['tipo_cambio_id'].'<br>';
                $query = 'SELECT monto,moneda from tipo_de_cambios where id='.$value['tipo_cambio_id'];
                $tipoCm = DB::select($query);
                $tipoCm = $this->object_to_array($tipoCm);
                //echo $tipoCm[0]['moneda'].'<br>';
                if($tipoCm[0]['moneda']=='USD'){

                    $porcentajeTipoCambioUSx = floatval($porcentajeTipoCambioUS) / 100;
                    $x = (floatval($tipoCm[0]['monto']) * floatval($porcentajeTipoCambioUSx));
                 
                    $tipoCambiTotal = floatval($tipoCm[0]['monto']) + floatval($x);
                }else{
                    $porcentajeTipoCambioEUx = floatval($porcentajeTipoCambioEU) / 100;
                    $x = (floatval($tipoCm[0]['monto']) * floatval($porcentajeTipoCambioEUx));
                    $tipoCambiTotal = floatval($tipoCm[0]['monto']) * floatval($x);
                }
                //echo $tipoCm[0]['monto'].'-'.$tipoCambiTotal.'<br>';

                $total += floatval($value['total']) * floatval($tipoCambiTotal);
                $totalSinConversion += floatval($value['total']);
        }

       //exit();

        $total = str_replace(',', '', number_format($total,2));
        //echo $total;
        $cliente =  Cliente::find(Auth::user()->cliente->idCliente);
        //dd($cliente);
        //echo $cliente->nombre;
        //exit();
       /* $item = new Item();
        $item->title = $servicios;
        $item->quantity = 1;
        $item->unit_price = $totalCarrito;
        $preference->items = array($item);
        $preference->save();*/
        $order = rand(1,1000);
        //$bbva = Bbva::getInstance('moiep6umtcnanql3jrxp', 'sk_3433941e467c4875b178ce26348b0fac');
        $bbva = Bbva::getInstance('mptdggroasfcmqs8plpy', 'sk_326c6d0443f6457aae29ffbd48f7d1be');

	//$total = 1.00;
        $chargeRequest = array(
            'affiliation_bbva' => '781500',
            'amount' => $total,
            'description' => 'servicios',
            'currency' => 'MXN',
            'order_id' => 'oid-'.$order,
            'redirect_url' => 'https://sistema.aviation-system.com/procesar_pago_pendiente/'.$stringEnvio.'/'.$total,
            'customer' => array(
                'name' => $cliente->nombre,
                'last_name' => '',
                'email' => $cliente->email,
                'phone_number' => $cliente->telefono)
        );

        $charge = $bbva->charges->create($chargeRequest);
        //return view('servicios.pagoprueba')->with('preference',$charge->payment_method->url)->with('total',$totalCarrito);
        //return route('pagarpendientes', ['id' => $re->string;]);

        $res = array('urlPago' => $charge->payment_method->url,'total' => number_format($totalSinConversion,2));
        return response()->json($res);
    }
    public function procesar_pago_pendiente($id,$total,Request $req){
	 $bbva = Bbva::getInstance('mtupve4cduwfgbewhado', 'sk_0acd90e6144d479d9ac712a5445d8153');
        //$bbva = Bbva::getInstance('mitwmpcuczp60s43iuhx', 'sk_86f04daee48843ecbaf88926755650ed');
        //Bbva::getSandboxMode(false);
        Bbva::setProductionMode(true);
        //$bbva = Bbva::getInstance('mptdggroasfcmqs8plpy', 'sk_326c6d0443f6457aae29ffbd48f7d1be');
        $charge = $bbva->charges->get($req->id);
	//echo $id.'>'.$req->id;
	if($charge->status=='completed'){
        $ids = trim($id,'-');
        $arrIds = explode('-', $ids);
        foreach ($arrIds as $key => $value) {
            $idIns = DB::table('ventas')
                ->where('id',$value)
                ->update([
                    'payment_id' => $req->id,
                    'estatus' => 2,
                ]);
	}
	$idPayment = $req->id;
        $totalCarrito = $total;
        $moneda = 'EUR';
	$this->envia_comprobante2($ids,$idPayment,$totalCarrito,$moneda);	
	return view('carrito.pago_result')->with('id_venta',$ids)->with('estatus',1)->with('total',$total);
	}else{
	return view('carrito.pago_result')->with('id_venta',0)->with('estatus',0)->with('total',$total);
	}
    }
    public function paga_venta(Request $req){
  //  	ini_set('display_errors', 1);
//	error_reporting(E_ALL);
        $files = $req->file('file');
        $facturasFN = '';
        //dd($files);
	//exit();
	//	echo 'deeeee';
       if($files[0]!=null){
         foreach ($files as $file) {

             $extension = $file->getClientOriginalExtension();
             $nombre = $file->getClientOriginalName();
             //echo $nombre.'--'.File::get($file);
             $facturasFN .= $nombre;
             // echo $nombre.'.'.$extension;
            //$file->store('users/' . $this->user->id . '/messages');
            //$nombreFile = $file->getClientOriginalName();
            //$path = public_path() . "/imagenes/organizacion/".$file->getClientOriginalName().'.'.$extension;
            //echo public_path();
            //exit();
            //$file->move(public_path() . "../storage/", $nombre);
            //echo $file->getClientOriginalPath();
            //move_uploaded_file($file->file('file'), $path);

            //Storage::disk('local')->put( $nombre,  File::get($file) );
        }

       }
	//echo 'xxxxeeee';
	//exit();
        $organizacion =  Organizacion::find(1);
        $totalCarrito = 0;
        $ivaIAS = 0;
        $ivaBan = 0;
        $comisionIAS = 0;
        $comisionBanc = 0;
        foreach (session()->get('cart') as $key => $value) {
            $totalCarrito += floatval($value['total']);
            $ivaIAS += floatval($value['ivaIAS']);
            $ivaBan += floatval($value['ivaBan']);
            $moneda = $value['moneda'];
            $idTC = $value['idTC'];
            $comisionIAS += floatval($value['comisionIAS']);
            $comisionBanc += floatval($value['comisionBanc']);
            $porComIas = $value['porComIas'];
        }

        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d H:i:s");


            /*$idIns = DB::table('ventas')->insertGetId([
                'idCliente' =>  Auth::user()->cliente->idCliente,
                'total' => $totalCarrito,
                'payment_id' => $req->payment_id,
                'moneda' => 1,
                'fecha' => $fechaactual,
                'tipo' => 1,
                'estatus' => 2,
            ]);*/

                $nuevaVenta = Venta::create([
                    'idCliente' => Auth::user()->cliente->idCliente,
                    'total' => $totalCarrito,
                    'iva_comision' => $ivaIAS,
                    'iva_bancaria' => $ivaBan,
                    'payment_id' => $req->id,
                    'moneda' => $moneda,
                    'tipo_cambio_id' => $idTC,
                    'porcentaje_tipo_cambio' => (  ($moneda == 'USD') ? $organizacion->porcentaje_dolar : $organizacion->porcentaje_euro  ),
                    'fecha' => $fechaactual,
                    'tipo' => 1,
                    'comision_bancaria' => $comisionBanc,
                    'comision_integrity' => $comisionIAS,
                    'porcentaje_comision_bancaria' => $organizacion->comision_bancario,
                    'porcentaje_comision_integrity' => $porComIas,
                    'comentarios' => session('comentarios'),
                    'estatus' => 1,
                    'factura_url' => ''
                ]);

            foreach (session()->get('cart') as $key => $value) {
                $idIns2 = DB::table('ventas_servicios')->insertGetId([
                    'id_venta' => $nuevaVenta->id,
                    'id_servicio' => $value['idServicio'],
                    'precio_unitario' => $value['costo'],
                    'subtotal' => $value['subtotal'],
                    'precio_total' => $value['total'],
                    'cantidad' => $value['cantidad'],
                    'comision_integrity' => $value['comisionIAS'],
                    'comision_bancaria' => $value['comisionBanc'],
                    'iva_integrity' => $value['ivaIAS'],
                    'iva_comision_bancaria' =>$value['ivaBan']

                ]);

            }

        	if($files[0]!=null){
		 $contador = 0;
                 $namesFilesSql = '';
                 foreach ($files as $file) {

                         $extension = $file->getClientOriginalExtension();
                         $nombre = $file->getClientOriginalName();
                         //echo $nombre.'--'.File::get($file);
			 $facturasFN .= $nombre;
			 if($contador>0){
                            $namefile = $nuevaVenta->id.'-'.$contador;
                         }else{
                            $namefile = $nuevaVenta->id;
                         }
                         $namesFilesSql.=$namefile.'.pdf,';
                         // echo $nombre.'.'.$extension;
                        //$file->store('users/' . $this->user->id . '/messages');
                        //$nombreFile = $file->getClientOriginalName();
                        //$path = public_path() . "/imagenes/organizacion/".$file->getClientOriginalName().'.'.$extension;
                        //echo public_path();
                        //exit();
                        //$file->move(public_path() . "../storage/", $nombre);
                        //echo $file->getClientOriginalPath();
                        //move_uploaded_file($file->file('file'), $path);

			 Storage::disk('local')->put( $namefile.'.pdf',  File::get($file) );
			 $contador++;
		     }
                        $idIns = DB::table('ventas')
                        ->where('id',$nuevaVenta->id)
                        ->update([
                            'factura_url' => trim($namesFilesSql,','),
                        ]);


                }
            $res = array('result' => 1,'idVenta' => $nuevaVenta->id);
            //echo json_encode($res);
            return response()->json($res);
    }
    public function paga_vent___a(Request $req){

        $files = $req->file('file');
        $facturasFN = '';
      // dd($files);
       // exit();
       if($files[0]!=null){
         foreach ($files as $file) {
		 //dd($file);
	//	 echo File::get($file);
             $extension = $file->getClientOriginalExtension();
	     $nombre = $file->getClientOriginalName();
	     //echo $file->getPathname;
             $facturasFN .= $nombre;
              //echo $nombre.'.'.$extension;
            //$file->store('users/' . $this->user->id . '/messages');
            //$nombreFile = $file->getClientOriginalName();
           // $path = public_path() . "/imagenes/organizacion/".$file->getClientOriginalName().'.'.$extension;
	 // º   Storage::disk('local')->put( $nombre ,  File::get($file) );
//	     echo public_path();
	     //move_uploaded_file(,public_path."../storage/".$nombre);
	     //$file->move(public_path() . "../storage/", $nombre);
            //echo $file->getClientOriginalPath();
            //move_uploaded_file($file->file('file'), $path);
        }
            //exit();
       }

        $organizacion =  Organizacion::find(1);
        $totalCarrito = 0;
        $ivaIAS = 0;
        $ivaBan = 0;
        $comisionIAS = 0;
        $comisionBanc = 0;
        foreach (session()->get('cart') as $key => $value) {
            $totalCarrito += floatval($value['total']);
            $ivaIAS += floatval($value['ivaIAS']);
            $ivaBan += floatval($value['ivaBan']);
            $moneda = $value['moneda'];
            $idTC = $value['idTC'];
            $comisionIAS += floatval($value['comisionIAS']);
            $comisionBanc += floatval($value['comisionBanc']);
            $porComIas = $value['porComIas']; 
        }

        date_default_timezone_set('America/Mexico_City');
        $fechaactual = date("Y-m-d H:i:s");
       

            /*$idIns = DB::table('ventas')->insertGetId([
                'idCliente' =>  Auth::user()->cliente->idCliente,
                'total' => $totalCarrito,
                'payment_id' => $req->payment_id,
                'moneda' => 1,
                'fecha' => $fechaactual,
                'tipo' => 1,
                'estatus' => 2,
            ]);*/

                $nuevaVenta = Venta::create([
                    'idCliente' => Auth::user()->cliente->idCliente,
                    'total' => $totalCarrito,
                    'iva_comision' => $ivaIAS,
                    'iva_bancaria' => $ivaBan,
                    'payment_id' => $req->id,
                    'moneda' => $moneda,
                    'tipo_cambio_id' => $idTC,
                    'porcentaje_tipo_cambio' => (  ($moneda == 'USD') ? $organizacion->porcentaje_dolar : $organizacion->porcentaje_euro  ),
                    'fecha' => $fechaactual,
                    'tipo' => 1,
                    'comision_bancaria' => $comisionBanc,
                    'comision_integrity' => $comisionIAS,
                    'porcentaje_comision_bancaria' => $organizacion->comision_bancario,
                    'porcentaje_comision_integrity' => $porComIas,
                    'comentarios' => session('comentarios'),
                    'estatus' => 1,
                    'factura_url' => trim($facturasFN,',')
                ]);

            foreach (session()->get('cart') as $key => $value) {
                $idIns2 = DB::table('ventas_servicios')->insertGetId([
                    'id_venta' => $nuevaVenta->id,
                    'id_servicio' => $value['idServicio'],
                    'precio_unitario' => $value['costo'],
                    'subtotal' => $value['subtotal'],
                    'precio_total' => $value['total'],
                    'cantidad' => $value['cantidad'],
                    'comision_integrity' => $value['comisionIAS'],
                    'comision_bancaria' => $value['comisionBanc'],
                    'iva_integrity' => $value['ivaIAS'],
                    'iva_comision_bancaria' =>$value['ivaBan']

                ]);
                  
            }
            $res = array('result' => 1,'idVenta' =>$nuevaVenta->id );
            //echo json_encode($res);
            return response()->json($res);
    }
   /* public function pvp(Request $r){
        //echo $r->string;
        return view('servicios.pagoprueba')->with('preference','wwww.deded.com')->with('total',450);
    }*/
        public function envia_comprobante($id,$idPayment,$totalCarrito,$moneda){
//ini_set('display_errors', 1);
//error_reporting(E_ALL);
	/*$id=98;

         $idVenta = $id;
          $idPayment = 'dkeodekdoekode';
          $total = '489595';
          $moneda = 'USD';  */
            $idVenta = $id;
        $query = 'select vs.*,s.nombre,s.numero_servicio, v.comision_bancaria as cb
                from ventas_servicios vs
                left join ias_servicio s on vs.id_servicio=s.idServicio
                left join ventas v on vs.id_venta=v.id
                where vs.id_venta='.$id;
        $servicios = DB::select($query);

        $query= 'SELECT c.idCuba,c.nombre,c.direccion,c.email,c.telefono,v.fecha
                from ventas v
                left join ias_clientes c on v.idCliente=c.idCliente
                where v.id='.$id;
        $cliente = DB::select($query);
        $cliente = $this->object_to_array($cliente);
	$ventaGenerales =  Venta::find($idVenta);
        $totalGeneVenta = $ventaGenerales->total;

        $query = 'SELECT monto,moneda from tipo_de_cambios where id='.$ventaGenerales->tipo_cambio_id;
        $tipoCm = DB::select($query);
        $tipoCm = $this->object_to_array($tipoCm);

        $porcentajeTipoCambioUS = $ventaGenerales->porcentaje_tipo_cambio;
        $porcentajeTipoCambioUSx = floatval($porcentajeTipoCambioUS) / 100;
        $x = (floatval($tipoCm[0]['monto']) * floatval($porcentajeTipoCambioUSx));      
        $tipoCambiTotal = floatval($tipoCm[0]['monto']) + floatval($x);
        $totalEnPesos = floatval($totalGeneVenta) * floatval($tipoCambiTotal);
        $totalEnPesos = number_format($totalEnPesos,2);
        $totalGeneVenta = number_format($totalGeneVenta,2);       

	$organizacion =  Organizacion::find(1);
	
	$urlSave = storage_path('app/public/comprobantes/') . 'comprobante_'.$id.'.pdf';
       // echo $urlSave;
     //   exit();
	$pdf = PDF::loadView('emails.pdfe',array('organizacion' => $organizacion,'servicios' => $servicios,'cliente' => $cliente,'idVenta' => $id,'moneda' => $moneda,'totalVenta' => $totalGeneVenta,'totalPesos' => $totalEnPesos,'TPcambio'=>number_format($tipoCambiTotal,2)))->save($urlSave); 
	sleep(4);
        //return $pdf->download('preubapdf.pdf');
        //$pdf = PDF::make('dompdf.wrapper');
        //$pdf->loadHTML($view);
        //return $pdf->stream('invoice');
         $subject = "Asunto de";
	$for = "omar.vazquezsanchez2290@gmail.com";
//	$for = 'finance@aviationsystem.com.mx';
	$for = $cliente[0]['email'];
        /*Mail::send('email',$request->all(), function($msj) use($subject,$for){
            $msj->;from("tucorreo@gmail.com","NombreQueApareceráComoEmisor");
            $msj->subject($subject);
            $msj->to($for);
        });*/
         Mail::send('emails.comprobantepago2', ['idVenta'=>$idVenta,'idPayment'=>$idPayment,'total'=>$totalCarrito,'moneda'=>$moneda], function ($m) use ($subject,$for,$urlSave) {
            $m->from('Integrityaviationsystem@gmail.com', 'Integirty Aviation System');
            $m->attach($urlSave);
            $m->to($for, $for)->subject($subject);
    });
	}
         function pendientesNew($ids,Request $q){

        $organizacion =  Organizacion::find(1);
        $porcentajeTipoCambioUS = $organizacion->porcentaje_dolar;
        $porcentajeTipoCambioEU = $organizacion->porcentaje_euro;
        //echo $ids;
        $idsTrimeados = trim($ids,'-');
        $idsArray = explode('-',$idsTrimeados);
        $contador = 1;
        $servicios = array();
        $totalEnPesos = 0;
        foreach ($idsArray as $key => $value) {
            $select1 = 'SELECT * from ventas where id='.$value;
            $ventasGenerales = DB::select($select1);
            $ventasGenerales = $this->object_to_array($ventasGenerales);

                //echo 'e-'.$value['tipo_cambio_id'].'<br>';
                $query = 'SELECT monto,moneda from tipo_de_cambios where id='.$ventasGenerales[0]['tipo_cambio_id'];
                $tipoCm = DB::select($query);
                $tipoCm = $this->object_to_array($tipoCm);
                //echo $tipoCm[0]['moneda'].'<br>'.$porcentajeTipoCambioEU;
                if($tipoCm[0]['moneda']=='USD'){

                    $porcentajeTipoCambioUSx = floatval($porcentajeTipoCambioUS) / 100;
                    $x = (floatval($tipoCm[0]['monto']) * floatval($porcentajeTipoCambioUSx));
                 
                    $tipoCambiTotal = floatval($tipoCm[0]['monto']) + floatval($x);
		}else{
			$porcentajeTipoCambioEUx = floatval($porcentajeTipoCambioEU) + 100;
                    //echo $porcentajeTipoCambioEUx.'>';
                    //echo 'S'.$tipoCm[0]['monto'];
                    $tipoCambiTotal = (floatval($tipoCm[0]['monto']) / 100) * $porcentajeTipoCambioEUx;
                    //$x = (floatval($tipoCm[0]['monto']) * floatval($porcentajeTipoCambioEUx)) /100;
                    //echo '<br>?'.$x.'+'.$tipoCm[0]['monto'];
                    //$ajala = $x+$tipoCm[0]['monto'];
                    //$tipoCambiTotal = $tipoCm[0]['monto'] + $x;
                    //echo '<br>Total='.$tipoCambiTotal;
                }
                //echo $tipoCm[0]['monto'].'-'.$tipoCambiTotal.'<br>';
		$ventasGenerales[0]['tcAumentado'] = round($tipoCambiTotal,2);
                $totalEnPesos += ($ventasGenerales[0]['total'] * round($tipoCambiTotal,2));	       
       	       //  print_r($ventasGenerales);
                //exit();
                //$total += floatval($value['total']) * floatval($tipoCambiTotal);
                //$totalSinConversion += floatval($value['total']);



            $servicios[$key] = $ventasGenerales;
            $select2 = 'SELECT vs.*,s.nombre as nombreservicio
                        from ventas_servicios vs
                        left join ias_servicio s on vs.id_servicio=s.idServicio
                        where vs.id_venta='.$value;
            $ventasServicios = DB::select($select2);
            $ventasServicios = $this->object_to_array($ventasServicios);
            $servicios[$key]['servicios'] = $ventasServicios;   
            //echo '--------------<br>';        
        }
        //  exit();
        $totalEnPesos = str_replace(',', '', number_format($totalEnPesos,2));
        $cliente =  Cliente::find(Auth::user()->cliente->idCliente);
        $order = rand(1,100000000);
        //$bbva = Bbva::getInstance('moiep6umtcnanql3jrxp', 'sk_3433941e467c4875b178ce26348b0fac');
       // $bbva = Bbva::getInstance('mptdggroasfcmqs8plpy', 'sk_326c6d0443f6457aae29ffbd48f7d1be');
	$bbva = Bbva::getInstance('mtupve4cduwfgbewhado', 'sk_0acd90e6144d479d9ac712a5445d8153');
	Bbva::setProductionMode(true);
	//$totalEnPesos = 1.00;
        $chargeRequest = array(
            'affiliation_bbva' => '4273468',
            'amount' => $totalEnPesos,
            'description' => 'servicios',
            'currency' => 'MXN',
            'order_id' => 'oid-'.$idsTrimeados.'-'.$order,
            'redirect_url' => 'https://sistema.aviation-system.com/procesar_pago_pendiente/'.$idsTrimeados.'/'.$totalEnPesos,
            'customer' => array(
                'name' => $cliente->nombre,
                'last_name' => '',
                'email' => $cliente->email,
                'phone_number' => $cliente->telefono)
        );

        $charge = $bbva->charges->create($chargeRequest);
        //return view('servicios.pagoprueba')->with('preference',$charge->payment_method->url)->with('total',$totalCarrito);
        //return route('pagarpendientes', ['id' => $re->string;]);

        //$res = array('urlPago' => $charge->payment_method->url,'total' => number_format($totalSinConversion,2),'ventas' => $ventas,'totalMx' => number_format($total,2) );
        //exit();
	return view('carrito.carritopendientes')->with('servicios',$servicios)->with('ids',$idsTrimeados)->with('total',number_format($totalEnPesos,2))->with('url',$charge->payment_method->url);       
	exit();
    }
    public function descargarComprobante(Request $request, \App\Venta $transaction){
        //echo 'deeeee';
          return response()->download( storage_path('app'). '/public/comprobantes/comprobante_' . $transaction->id.'.pdf' );
    }
    public function envia_comprobante2($id,$idPayment,$totalCarrito,$moneda){
        /*$id=98;

         $idVenta = $id;
          $idPayment = 'dkeodekdoekode';  
          $total = '489595';
          $moneda = 'USD';  */ 
          $arr = explode('-', $id);
          $totalGeneVenta2 = 0;
	  $totalEnPesos2 = 0;
	  $cont = 0;
          foreach ($arr as $key => $value) {
            $id = $value;
               $query = 'select vs.*,s.nombre,s.numero_servicio, v.comision_bancaria as cb
                from ventas_servicios vs
                left join ias_servicio s on vs.id_servicio=s.idServicio
                left join ventas v on vs.id_venta=v.id
                where vs.id_venta='.$id;
            $servicios = DB::select($query);
	    $servicios2[$cont] = $servicios[0];
	    $cont++;
            $query= 'SELECT c.idCuba,c.nombre,c.direccion,c.email,c.telefono,v.fecha
                from ventas v 
                left join ias_clientes c on v.idCliente=c.idCliente
                where v.id='.$id;
            $cliente = DB::select($query);        
            $cliente = $this->object_to_array($cliente);

            $ventaGenerales =  Venta::find($id);
            $totalGeneVenta = $ventaGenerales->total;

            $query = 'SELECT monto,moneda from tipo_de_cambios where id='.$ventaGenerales->tipo_cambio_id;
            $tipoCm = DB::select($query);
            $tipoCm = $this->object_to_array($tipoCm);

            $porcentajeTipoCambioUS = $ventaGenerales->porcentaje_tipo_cambio;
            $porcentajeTipoCambioUSx = floatval($porcentajeTipoCambioUS) / 100;
            $x = (floatval($tipoCm[0]['monto']) * floatval($porcentajeTipoCambioUSx));      
            $tipoCambiTotal = floatval($tipoCm[0]['monto']) + floatval($x);
            $totalEnPesos = floatval($totalGeneVenta) * floatval($tipoCambiTotal);

            $totalGeneVenta2 +=$totalGeneVenta;
            $totalEnPesos2 +=$totalEnPesos;
          }
        $idVenta = $id;
      
        

        

        

        
        $totalEnPesos = number_format($totalEnPesos2,2);
        $totalGeneVenta = number_format($totalGeneVenta2,2);

        $organizacion =  Organizacion::find(1);
	
	foreach ($arr as $key => $value) {
        $id = $value;
        $urlSave = storage_path('app/public/comprobantes/') . 'comprobante_'.$id.'.pdf';
        //echo $urlSave;
        //exit();
        $pdf = PDF::loadView('emails.pdfe',array('organizacion' => $organizacion,'servicios' => $servicios2,'cliente' => $cliente,'idVenta' => $id,'moneda' => $moneda,'totalVenta' => $totalGeneVenta,'totalPesos' => $totalEnPesos,'TPcambio'=>number_format($tipoCambiTotal,2)))->save($urlSave); 
	}       
	sleep(4);
        //return $pdf->download('preubapdf.pdf');
        //$pdf = PDF::make('dompdf.wrapper');
        //$pdf->loadHTML($view);
        //return $pdf->stream('invoice');
        $subject = "Asunto de";
        $for = "omar.vazquezsanchez2290@gmail.com";
        $for = $cliente[0]['email'];
         Mail::send('emails.comprobantepago2', ['idVenta'=>$idVenta,'idPayment'=>$idPayment,'total'=>$totalCarrito,'moneda'=>$moneda], function ($m) use ($subject,$for,$urlSave) {
            $m->from('Integrityaviationsystem@gmail.com', 'Integirty Aviation System');
            $m->attach($urlSave);
            $m->to($for, $for)->subject($subject);
        });
    }
    public function descargarTerminos(Request $request){
        //echo 'deeeee';
          return response()->download( storage_path('app'). '/terminos_condiciones.pdf' );
    }
    public function descargarPrivacidad(Request $request){
        //echo 'deeeee';
          return response()->download( storage_path('app'). '/aviso_privacidad.pdf' );
    }
}
   
