<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/
/*
Route::get('/inicio', function () {
    return view('clientmenu');
});

Route::get('/', function () {
    return view('login');
});

Route::post('/login',               '\App\Http\Controllers\UserController@login');
Route::get('/recuperar',            '\App\Http\Controllers\UserController@recuperar');
Route::post('/correoRecuperacion',  '\App\Http\Controllers\UserController@correoRecuperacion');
Route::get('/registrate',           '\App\Http\Controllers\UserController@registro');
Route::post('/registro',            '\App\Http\Controllers\UserController@agregarRegistro');
*/






// Authentication Routes...

Route::get('login', 'Auth\AuthController@showLoginForm')->name('login');
Route::post('login', 'Auth\AuthController@login');
Route::get('logout', 'Auth\AuthController@logout');

// Registration Routes...
Route::get('register', 'Auth\AuthController@showRegistrationForm');
Route::post('register', 'Auth\AuthController@register');

// Password Reset Routes...
Route::get('password/reset/{token?}', 'Auth\PasswordController@showResetForm');
Route::post('password/email', 'Auth\PasswordController@sendResetLinkEmail');
Route::post('password/reset', 'Auth\PasswordController@reset');

Route::get('/home', 'HomeController@index');
Route::post('/cambia_idioma', 'HomeController@cambia_idioma')->name('cambia_idioma');

Route::group([
    'middleware' => [ 'auth', 'locale']
], function() {

   		Route::get('/', 'HomeController@index');

		
		Route::get('/ventas',            '\App\Http\Controllers\ServicioController@gridServiciosVentas');

		Route::get('/pagosprueba',            '\App\Http\Controllers\ServicioController@pagos_prueba');
		Route::get('/pagar/{id}',            '\App\Http\Controllers\CarritoController@pagar');

		Route::post('/add_cart_item',        '\App\Http\Controllers\CarritoController@addItemCart');
		Route::post('/add_cart_item2',        '\App\Http\Controllers\CarritoController@updateItemCart2');
		Route::get('/carrito',        '\App\Http\Controllers\CarritoController@carrito');
		Route::post('/vacia_carrito',        '\App\Http\Controllers\CarritoController@vaciaCarito');
		Route::post('/elimina_item',        '\App\Http\Controllers\CarritoController@eliminaItemCarrito');
		Route::get('/procesar_pago/{id}',        '\App\Http\Controllers\CarritoController@procesar_pago');
		Route::get('/procesar_pago_pendiente/{id}/{total}',        '\App\Http\Controllers\CarritoController@procesar_pago_pendiente');
		
		Route::get('/procesar_pago2',        '\App\Http\Controllers\CarritoController@procesar_pago2');
	Route::get('/bbva',        '\App\Http\Controllers\CarritoController@bbva');

	Route::post('pagar_pendientes',        '\App\Http\Controllers\CarritoController@pagarPendientesBBVA');
	Route::get('pagarpendientes/{id}',        '\App\Http\Controllers\CarritoController@pvp');
        Route::get('pagarpendientes_new/{id}',        '\App\Http\Controllers\CarritoController@pendientesNew');	

	Route::get('/customers/{customer}/transactions', 					'\App\Http\Controllers\TransactionController@index');
	Route::get('/customers/{customer}/transactions/{transaction}', 					'\App\Http\Controllers\TransactionController@show');
	Route::post('/get_venta_info',        '\App\Http\Controllers\CarritoController@getInfoVenta');
	Route::get('pagarPendiente/{id}',        '\App\Http\Controllers\CarritoController@pagarPendiente');
	Route::post('/trae_tipocambio',        '\App\Http\Controllers\CarritoController@trae_tipocambio');
	Route::post('/trae_rangos',        '\App\Http\Controllers\CarritoController@trae_rangos');
	Route::post('/add_comentarios',        '\App\Http\Controllers\CarritoController@paga_venta');
	Route::get('/descarga_fact/{factura_url}',            '\App\Http\Controllers\ServicioController@descarga_fact');
	Route::get('/customers/transactions/{transaction}/factura', 	'\App\Http\Controllers\TransactionController@descargarFactura');
	Route::get('/{transaction}/comprobante', 				'\App\Http\Controllers\CarritoController@descargarComprobante');
	Route::get('/terminosycondiciones', 				'\App\Http\Controllers\CarritoController@descargarTerminos');
	Route::get('/avisoprivacidad', 				'\App\Http\Controllers\CarritoController@descargarPrivacidad');
	Route::get('/setings_pass', '\App\Http\Controllers\ClienteController@seeData');
	Route::post('/cambia_password', '\App\Http\Controllers\ClienteController@cambia_password');

	Route::get('/change-password',  'Auth\ChangePasswordController@index');
	Route::post('/change-password',  'Auth\ChangePasswordController@changePassword');
	Route::get('/transactions/{transaction}/factura',                                       '\App\Http\Controllers\TransactionController@descargarFactura');
});


Route::group([
    'prefix' => 'admin',
    'middleware' => ['auth', 'admin', 'locale']
], function() {
	
	Route::get('/config/user/create',            '\App\Http\Controllers\UserController@create');
	Route::post('/config/user/store',            '\App\Http\Controllers\UserController@store');

	Route::get('/config/user/index',            '\App\Http\Controllers\UserController@index');

	Route::get('/customers', 					'\App\Http\Controllers\TransactionController@customerIndex');

	Route::get('/transactions', 					'\App\Http\Controllers\TransactionController@create');
	Route::post('/transactions', 					'\App\Http\Controllers\TransactionController@store');
	Route::get('/transactions/{transaction}', 					'\App\Http\Controllers\TransactionController@edit');
	Route::post('/transactions/{transaction}', 					'\App\Http\Controllers\TransactionController@update');
	Route::post('/transactions/{transaction}/confirm', 					'\App\Http\Controllers\TransactionController@confirm');
	Route::delete('/transactions/{transaction}/{line}', 					'\App\Http\Controllers\TransactionController@customerIndex');


	Route::post('/transactions/{transaction}/factura', 					'\App\Http\Controllers\TransactionController@factura');
	Route::get('/transactions/{transaction}/factura', 					'\App\Http\Controllers\TransactionController@descargarFactura');

	Route::get('/config/foreignexchange/{currency}', 		'\App\Http\Controllers\MonedaController@edit');
	Route::post('/config/foreignexchange/{currency}', 		'\App\Http\Controllers\MonedaController@update');


	////Configuracion Gen
	Route::get('/configgeneral',        '\App\Http\Controllers\ConfiguracionGeneralController@index');
	Route::post('guarda_config_g',        '\App\Http\Controllers\ConfiguracionGeneralController@guardaConfigG');

	Route::get('/clientes',            '\App\Http\Controllers\ClienteController@gridClientes');
	Route::post('save_cliente',        '\App\Http\Controllers\ClienteController@saveCliente');
	Route::post('get_clientes',        '\App\Http\Controllers\ClienteController@getClientes');
	Route::post('save_prove',        '\App\Http\Controllers\ClienteController@saveProve');
	Route::post('datos_cliente',        '\App\Http\Controllers\ClienteController@datosCliente');
	Route::post('import_excel',        '\App\Http\Controllers\ClienteController@import_excel');

	

	Route::get('/serviciosgrid',            '\App\Http\Controllers\ServicioController@gridServicios');
	Route::post('save_servicio',        '\App\Http\Controllers\ServicioController@saveServicio');
	Route::post('servicios_table',        '\App\Http\Controllers\ServicioController@getTableServicios');
	Route::get('/rangos',            '\App\Http\Controllers\ClienteController@rangos');
	Route::post('datos_servicio',        '\App\Http\Controllers\ServicioController@datosServicio');

	Route::post('get_rangos',        '\App\Http\Controllers\ClienteController@getRangos');
	Route::post('save_rango',        '\App\Http\Controllers\ClienteController@guardaRango');
	Route::post('datos_rango',        '\App\Http\Controllers\ClienteController@datosRango');

	Route::post('/cambia_idioma', 'HomeController@cambia_idioma');	
	 Route::post('/transactions/cambia_idioma', 'HomeController@cambia_idioma');	
	Route::post('/config/cambia_idioma', 'HomeController@cambia_idioma');
	Route::post('/admin/transactions/cambia_idioma', 'HomeController@cambia_idioma');
	Route::post('/config/user/cambia_idioma', 'HomeController@cambia_idioma');
	Route::post('/admin/config/foreignexchange/{currency}/cambia_idioma', 'HomeController@cambia_idioma');
	Route::post('/customers/{customer}/transactions/cambia_idioma', 'HomeController@cambia_idioma');

});


