@extends('includes.navbarclient')
@section('content')
<div class="container-fluid" id="xd">
	<div class="row" style="height: 100%;">
		<!--<div class="col-2" style="background-color: #93a6b7">
			<div class="row">
				<div class="col-12">
					<h1>{{ trans( 'messages.servicios' ) }}</h1>
				</div>
			</div>
			<hr>
			<div class="row">
				<div class="col-12 alert alert-dark">
                    <br>
					<h5><a href="{{ asset('/admin/customers') }}">+ {{ trans( 'messages.servicios' ) }}</a></h5>
				</div>
			</div>
		</div>-->
		<div class="col-12" id="divFormCliente" >
			<div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <br>
                        <h5>+ {{ trans( 'messages.servicios' ) }}</h5>
                        <a href="{{ asset('/customers/'.$cliente->idCliente.'/transactions') }}" class="btn btn-primary" role="button" aria-pressed="true">
                            <svg width="1em" height="1em" viewBox="0 0 16 16" class="bi bi-arrow-left" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z"/>
                            </svg>
                            {{ trans( 'messages.regresar' ) }}
                        </a>


                        
                    </div>
                </div>

                <div class="row">
                    
                </div>


                <div class="row">
                    <div class="col-2">
                        <label for="">{{ trans( 'messages.fecha' ) }}</label>
                        <input type="text" value="{{ $venta->fecha  }}"  class="form-control" readonly>
                    </div>
                    <div class="col-2">
                        <label for="">{{ trans( 'messages.cliente' ) }}</label>
                        <input type="text" value="{{ $cliente->nombre }}" class="form-control" readonly>
                    </div>
                    <div class="col-2">
                        <label for="">{{ trans( 'messages.moneda' ) }}</label>
                        <input type="text" value="{{ $venta->moneda  }}" class="form-control" readonly>
                    </div>
                    <div class="col-2" style="display:none;">
                        <label for="">{{ trans( 'messages.tipo_cambio' ) }}</label>
                        <input type="text" value="${{ number_format($tipoDeCambio->monto, 2)  }}" class="form-control text-right" readonly>
                    </div>
                    <div class="col-2">
                    </div>
                </div>

                <div class="row">
                    <div class="col-2" style="display:none;">
                        <label for="">% {{ trans( 'messages.tipo_cambio' ) }}</label>
                        <input type="text" value="{{  number_format($venta->porcentaje_tipo_cambio, 2)  }}" class="form-control text-right" readonly>
                    </div>
                    <div class="col-2" style="display:none;">
                        <label for="">% {{ trans( 'messages.comision_integrity' ) }}</label>
                        <input type="text" value="{{ number_format($venta->porcentaje_comision_integrity, 2) }}" class="form-control text-right" readonly>
                    </div>
                    <div class="col-2" style="display:none;">
                        <label for="">{{ trans( 'messages.comision_bancaria' ) }}</label>
                        <input type="text" value="${{ number_format($venta->comision_bancaria, 2)  }}" class="form-control text-right" readonly>
                    </div>


                    
                    


                </div>
                <br>


                @can('upload')
                <form lass="form-horizontal" role="form" method="POST" action="{{ url('/admin/transactions/'.$venta->id).'/factura' }}" enctype="multipart/form-data">
                    {{ csrf_field() }}
                <div class="row">
                    <div class="col-6">

                    </div>
                    
                    <div class="col-3">
                        <label for="">{{ trans( 'messages.adjuntar_factura' ) }}</label>
		   	<input type="file" class="form-control" name="factura[]" multiple>
		    </div>
                    <div class="col-3">
                        <label for=""></label>
                        <button type="submit" class="form-control btn btn-dark">{{ trans( 'messages.subir_factura' ) }}</button>
                    </div>
                    
                </div>
                </form>
                <br>
                @endcan

                @if ( $venta->factura_url )
                    <div class="row">
                        <div class="col-6">

                        </div>
                        
                        <div class="col-6">
		            @can('admin')    
                 <a href="{{ url('/admin/transactions/'.$venta->id).'/factura' }}" class="form-control btn btn-dark" target="_blank">{{ trans( 'messages.descarga_factura' ) }}</a>
	    @else
		     <div class="row">
                    <div class="col-6">
                        <a href="{{ url('/customers/transactions/'.$venta->id).'/factura' }}" class="form-control btn btn-info" target="_blank">{{ trans( 'messages.descarga_factura' ) }}</a>
		    </div>
		    @if ( $venta->estatus==2 )
                    <div class="col-6">
                        <a href="{{ url('/'.$venta->id).'/comprobante' }}" class="form-control btn btn-info" target="_blank">{{ trans( 'messages.descarga_comprobante' ) }}</a> 
		    </div>
		    @endif
                </div>
            @endcan
			</div>
                    </div>
                    <br>
                @endif
                
                


                <div class="row">
                    <div class="col-12">
                        <table id="lines" class="table table-bordered table-hover" style="background-color: white;">
                            <thead>
                                <tr>
                                    <th>{{ trans('messages.servicio') }}</th>
                                    <th>{{ trans('messages.precio_unitario') }}</th>
                                    <th>{{ trans('messages.total') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ( $lineas as $venta )
                                    <tr>
                                        <td>{{ $venta->service->nombre  }}</td>
                                        <td class="text-right">${{ number_format($venta->precio_unitario, 2) }}</td>
                                        <td class="text-right">${{ number_format($venta->precio_total, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                        
                </div>
			</div>
		</div>
	</div>
</div>
<script>
    $(document).ready(function() {
        $('#lines').DataTable();
    } );
        function verFactura(ids){
        alert(ids)
        var URLdomain = window.location.host;
        alert(URLdomain);
        var idsarr = ids.split(',');
        $.each(idsarr, function(index, val) {
            alert(URLdomain+'/Integrity2/storage/app/'+val);
             window.open('https://'+URLdomain+'/Integrity2/storage/app/'+val, '_blank');
        });

    }
</script>
@endsection
